<?php $__env->startSection('bread-crumb'); ?>
    <div class="row mb-2">
        <div class="col-sm-6">
            <h1 class="text-capitalize"><?php echo e($user->fname); ?> <?php echo e($user->lname); ?></h1>
        </div>
        <div class="col-sm-6">
            <ol class="breadcrumb float-sm-right">
                <li class="breadcrumb-item"><a href="/dashboard">Dashboard</a></li>
                <li class="breadcrumb-item"><a href="/users">User</a></li>
                <li class="breadcrumb-item active text-capitalize"><?php echo e($user->fname); ?> <?php echo e($user->lname); ?></li>
            </ol>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>

<div class="card card-widget widget-user">
    <div class="widget-user-header bg-success">
        <h3 class="widget-user-username text-capitalize"><?php echo e($user->fname); ?> <?php echo e($user->lname); ?></h3>
        <h5 class="widget-user-desc"><?php echo e($user->email); ?></h5>
    </div>
    <div class="widget-user-image">
        <img class="img-circle elevation-2" src=" <?php echo e(asset('dist/svg-files/user-avatar.svg')); ?> " alt="User Avatar">
    </div>
    <div class="card-footer">
        <div class="row">
            <div class="col-sm-6 border-right">
                <div class="description-block">
                    <h5 class="description-header font-weight-light text-monospace">Hospital</h5>
                    <span class="description-text">
                        <?php if($assigned->hospital_id != null): ?>
                            <?php echo e($hospital->hospital); ?>

                        <?php else: ?>
                            -
                        <?php endif; ?>
                    </span>
                </div>
            </div>
            <div class="col-sm-6 border-right">
                <div class="description-block">
                    <h5 class="description-header font-weight-light text-monospace">Role</h5>
                    <span class="description-text">
                        <?php if($assigned->role == 1): ?>
                            Hospital User
                        <?php elseif($assigned->role == 2): ?>
                            HOD Head
                        <?php elseif($assigned->role == 3): ?>
                            Super Admin
                        <?php endif; ?>
                    </span>
                </div>
            </div>

        </div>
    </div>
</div>


<div class="card">
    <div class="card-header">
        <h3 class="card-title">AUDIT TRAIL</h3>

        <div class="card-tools">

        </div>
    </div>
    <!-- /.card-header -->
    <div class="card-body table-responsive ">
        <table class="table table-hover text-nowrap" id="example1">
            <thead>
                <tr>
                    <th style="width: 33%">Action</th>
                    <th style="width: 33%">Remarks</th>
                    <th style="width: 33%" class="text-center">Date</th>
                </tr>
            </thead>
            <tbody>
                <?php $__empty_1 = true; $__currentLoopData = $audit_trails; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                    <tr>
                        <td class="text-capitalize"><?php echo e($item->action); ?></td>
                        <td><?php echo e($item->remarks); ?></td>
                        <td class="text-center"><?php echo e($item->created_at); ?></td>
                    </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                    <tr>
                        <td colspan="3" class="text-center text-muted">Sorry, no audit trail found.</td>
                    </tr>
                <?php endif; ?>
            </tbody>
      </table>
    </div>
</div>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('script'); ?>
    <script>
        $(function () {
            $("#example1").DataTable({
                "responsive": true, "lengthChange": false, "autoWidth": false,
                "buttons": ["colvis"]
            }).buttons().container().appendTo('#example1_wrapper .col-md-6:eq(0)');
            //Initialize Select2 Elements
            $('.select2').select2()
        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/misnegros/public_html/staging-onehospital/resources/views/users/show.blade.php ENDPATH**/ ?>