<?php $__env->startSection('bread-crumb'); ?>
    <div class="row mb-2">
        <div class="col-sm-6">
        <h1>Create Doctor</h1>
        </div>
        <div class="col-sm-6">
        <ol class="breadcrumb float-sm-right">
            <li class="breadcrumb-item"><a href="/dashboard">Dashboard</a></li>
            <li class="breadcrumb-item active">Create Doctor</li>
        </ol>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<div class="card card-success card-outline card-tabs">
    <div class="card-body">
        <a href="/hospital/<?php echo e($hospital->id); ?>" class="btn btn-sm btn-success rounded-0" title="Return to <?php echo e($hospital->hospital); ?> dashboard">
            <i class="fa fa-chevron-left"></i> Return
        </a>
        <a href="/doctor-sched/create?hospital_id=<?php echo e($hospital->id); ?>" class="btn btn-sm btn-warning rounded-0">
            <i class="fa fa-calendar" aria-hidden="true"></i> Create Schedule
        </a>
        <h4 class="text-center text-uppercase">
            <?php echo e($hospital->hospital); ?>

        </h4>
        <hr>

        <form class="form-horizontal" action="/doctor" method="POST">
        <?php if(isset($doctor)): ?>
            <?php echo method_field('PUT'); ?>
        <?php endif; ?>

            <?php echo csrf_field(); ?>
            <div class="card-body">
                <div class="form-group row">
                    <label class="col-sm-2 col-form-label">Doctor *</label>
                    <div class="col-sm-10">
                        <?php if(isset($doctor)): ?>
                            <input type="text" class="form-control" name="doctor" value="<?php echo e($doctor->doctor); ?>" autofocus required>
                            <input type="hidden" name="id" value="<?php echo e($doctor->id); ?>">
                        <?php else: ?>
                            <input type="text" class="form-control" name="doctor" value="" autofocus required>
                            <input type="hidden" name="hospital_id" value="<?= $_GET['hospital_id'] ?>">
                        <?php endif; ?>
                    </div>
                </div>
                <div class="form-group row">
                    <label class="col-sm-2 col-form-label">Specialty *</label>
                    <div class="col-sm-10">
                        <?php if(isset($doctor)): ?>
                            <input type="text" class="form-control" name="specialty" value="<?php echo e($doctor->specialty); ?>" required>
                        <?php else: ?>
                            <input type="text" class="form-control" name="specialty" required>
                        <?php endif; ?>
                    </div>
                </div>

            </div>
            <div class="card-footer justify-content-center row">
                <button type="submit" class="btn btn-info">
                    <i class="fa fa-save mr-1"></i>

                    <?php if(isset($doctor)): ?>
                        UPDATE
                    <?php else: ?>
                        SAVE
                    <?php endif; ?>
                </button>
            </div>
        </form>
        <?php if(session()->has('doctor.store') || session()->has('doctor.update') || session()->has('doctor.destroy')): ?>
            <div class="alert alert-success alert-dismissible col-12 mt-3" id="alert">
                <button type="button" class="close" data-dismiss="alert" aria-hidden="true">&times;</button>
                <i class="icon fas fa-check"></i>
                <?php if(session()->get('doctor.store')): ?>
                    New doctor successfully added!
                <?php elseif(session()->get('doctor.update')): ?>
                    Update Successful!
                <?php elseif(session()->get('doctor.destroy')): ?>
                    Delete Successful!
                <?php endif; ?>
            </div>
        <?php endif; ?>
    </div>
    <hr>
    <div class="card-body table-responsive p-4">
        <table class="table table-hover text-nowrap">
            <thead>
                <tr>
                    <th>Doctor</th>
                    <th>Specialty</th>
                    <th></th>
                </tr>
            </thead>
            <tbody>
                <?php $__empty_1 = true; $__currentLoopData = $doctors; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $dr_item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                    <tr>
                        <td><?php echo e($dr_item->doctor); ?></td>
                        <td><?php echo e($dr_item->specialty); ?></td>
                        <td>
                            <div class="float-right d-flex">
                                <a href="/doctor/edit/<?php echo e($dr_item->id); ?>" class="btn btn-sm btn-info">
                                    <i class="fa fa-edit"></i>
                                </a>
                                &nbsp;
                                <form action="/doctor" method="post">
                                    <?php echo csrf_field(); ?>
                                    <?php echo method_field('DELETE'); ?>
                                    <input type="hidden" name="dr_id" value="<?php echo e($dr_item->id); ?>">
                                    <button type="submit" class="btn btn-sm btn-danger">
                                        <i class="fa fa-trash"></i>
                                    </button>
                                </form>
                            </div>
                        </td>
                    </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                    <tr>
                        <td colspan="3" class="text-center text-muted">No doctors found.</td>
                    </tr>
                <?php endif; ?>
            </tbody>
        </table>
    </div>

</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('script'); ?>
    <script>
        $(function(){
            //Initialize Select2 Elements
            $('.select2').select2()
        })
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/misnegros/public_html/staging-onehospital/resources/views/hospitals/doctor/create.blade.php ENDPATH**/ ?>