<?php $__env->startSection('bread-crumb'); ?>
    <div class="row mb-2">
        <div class="col-sm-6">
        <h1>Create Schedule</h1>
        </div>
        <div class="col-sm-6">
        <ol class="breadcrumb float-sm-right">
            <li class="breadcrumb-item"><a href="/dashboard">Dashboard</a></li>
            <li class="breadcrumb-item active">Create Bed</li>
        </ol>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<div class="card card-success card-outline card-tabs">
    <div class="card-body">
        <a href="/hospital/<?php echo e($hospital->id); ?>" class="btn btn-sm btn-success rounded-0" title="Return to <?php echo e($hospital->hospital); ?> dashboard">
            <i class="fa fa-chevron-left"></i> Return
        </a>
        <h4 class="text-center text-uppercase">
            <?php echo e($hospital->hospital); ?>

        </h4>
        <h5 class="text-center text-muted">NEW DOCTOR SCHEDULE</h5>
        <hr>

        <form class="form-horizontal" action="/doctor-sched" method="POST">
        <?php if(isset($doctor_sched)): ?>
            <?php echo method_field('PUT'); ?>
        <?php endif; ?>

            <?php echo csrf_field(); ?>
            <div class="card-body">
                <div class="form-group row">
                    <label class="col-sm-2 col-form-label">Doctor *</label>
                    <div class="col-sm-10">
                        <?php if(isset($doctor_sched)): ?>
                            <select class="form-control select2" name="doctor_id" style="width: 100%;" required>
                                <option value="">-</option>
                                <?php $__empty_1 = true; $__currentLoopData = $doctors; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $dr_item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                    <option value="<?php echo e($dr_item->id); ?>" <?php if($doctor_sched->doctor_id == $dr_item->id): ?> selected <?php endif; ?>><?php echo e($dr_item->doctor); ?></option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                <?php endif; ?>
                            </select>
                            <input type="hidden" name="id" value="<?php echo e($doctor_sched->id); ?>">
                            <input type="hidden" name="hospital_id" value="<?= $_GET['hospital_id'] ?>">
                        <?php else: ?>
                            <select class="form-control select2" name="doctor_id" style="width: 100%;" required>
                                <option value="">-</option>
                                <?php $__empty_1 = true; $__currentLoopData = $doctors; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $dr_item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                    <option value="<?php echo e($dr_item->id); ?>"><?php echo e($dr_item->doctor); ?></option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                    <option value="">No record found.</option>
                                <?php endif; ?>
                            </select>
                            <input type="hidden" name="hospital_id" value="<?= $_GET['hospital_id'] ?>">
                        <?php endif; ?>
                    </div>
                </div>
                <div class="form-group row">
                    <label class="col-sm-2 col-form-label">Day *</label>
                    <div class="col-sm-10">
                        <?php if(isset($doctor_sched)): ?>
                            <input type="date" class="form-control" name="day" value="<?php echo e($doctor_sched->day); ?>">
                        <?php else: ?>
                            <input type="date" class="form-control" name="day">
                        <?php endif; ?>
                    </div>
                </div>
                <div class="form-group row">
                    <label class="col-sm-2 col-form-label">IN *</label>
                    <div class="col-sm-10">
                        <?php if(isset($doctor_sched)): ?>
                            <input type="time" class="form-control" name="in" value="<?php echo e($doctor_sched->in); ?>">
                        <?php else: ?>
                            <input type="time" class="form-control" name="in">
                        <?php endif; ?>
                    </div>
                </div>
                <div class="form-group row">
                    <label class="col-sm-2 col-form-label">OUT *</label>
                    <div class="col-sm-10">
                        <?php if(isset($doctor_sched)): ?>
                            <input type="time" class="form-control" name="out" value="<?php echo e($doctor_sched->out); ?>">
                        <?php else: ?>
                            <input type="time" class="form-control" name="out">
                        <?php endif; ?>
                    </div>
                </div>
                <div class="form-group row">
                    <label class="col-sm-2 col-form-label">Department *</label>
                    <div class="col-sm-10">
                        <?php if(isset($doctor_sched)): ?>
                            <select class="form-control select2" name="department" style="width: 100%;" required>
                                <option value="">-</option>
                                <option value="dr" <?php if($doctor_sched->department == 'dr'): ?> selected <?php endif; ?>>Delivery Room</option>
                                <option value="er" <?php if($doctor_sched->department == 'er'): ?> selected <?php endif; ?>>Emergency Room</option>
                                <option value="or" <?php if($doctor_sched->department == 'or'): ?> selected <?php endif; ?>>Operating Room</option>
                                <option value="opd" <?php if($doctor_sched->department == 'or'): ?> selected <?php endif; ?>>Outpatient Department</option>
                            </select>
                        <?php else: ?>
                            <select class="form-control select2" name="department" style="width: 100%;" required>
                                <option value="">-</option>
                                <option value="dr">Delivery Room</option>
                                <option value="er">Emergency Room</option>
                                <option value="or">Operating Room</option>
                                <option value="opd">Outpatient Department</option>
                            </select>
                        <?php endif; ?>
                    </div>
                </div>
                <div class="form-group row">
                    <label class="col-sm-2 col-form-label">Remarks</label>
                    <div class="col-sm-10">
                        <?php if(isset($doctor_sched)): ?>
                            <textarea class="form-control" rows="3" name="remarks"><?php echo e($doctor_sched->remarks); ?></textarea>
                        <?php else: ?>
                            <textarea class="form-control" rows="3" name="remarks"></textarea>
                        <?php endif; ?>
                    </div>
                </div>


            </div>
            <div class="card-footer justify-content-center row">
                <button type="submit" class="btn btn-info">
                    <i class="fa fa-save mr-1"></i>

                    <?php if(isset($doctor_sched)): ?>
                        UPDATE
                    <?php else: ?>
                        SAVE
                    <?php endif; ?>
                </button>
            </div>
        </form>
        <?php if(session()->has('doc_sched.store') || session()->has('doc_sched.update') || session()->has('doc_sched.destroy')): ?>
            <div class="alert alert-success alert-dismissible col-12 mt-3" id="alert">
                <button type="button" class="close" data-dismiss="alert" aria-hidden="true">&times;</button>
                <i class="icon fas fa-check"></i>
                <?php if(session()->get('doc_sched.store')): ?>
                    New schedule successfully added!
                <?php elseif(session()->get('doc_sched.update')): ?>
                    Update Successful!
                <?php elseif(session()->get('doc_sched.destroy')): ?>
                    Delete Successful!
                <?php endif; ?>
            </div>
        <?php endif; ?>
    </div>
    <hr>
    <div class="card-body table-responsive p-4">
        <table class="table table-hover text-nowrap">
            <thead>
                <tr>
                    <th>Doctor</th>
                    <th>Day</th>
                    <th>IN</th>
                    <th>OUT</th>
                    <th>DESIGNATION</th>
                    <th>Remarks</th>
                    <th></th>
                </tr>
            </thead>
            <tbody>
                <?php $__empty_1 = true; $__currentLoopData = $schedules; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $sched_item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                    <tr>
                        <td><?php echo e($sched_item->doctor); ?></td>
                        <td><?php echo e($sched_item->day); ?></td>
                        <td><?php echo e($sched_item->in); ?></td>
                        <td><?php echo e($sched_item->out); ?></td>
                        <td>
                            <?php if($sched_item->department == 'er'): ?>
                                Emergency Room
                            <?php elseif($sched_item->department == 'dr'): ?>
                                Delivery Room
                            <?php elseif($sched_item->department == 'or'): ?>
                                Operating Room
                            <?php elseif($sched_item->department == 'opd'): ?>
                                Outpatient Department
                            <?php endif; ?>
                        </td>
                        <td><?php echo e($sched_item->remarks); ?></td>
                        <td>
                            <div class="float-right d-flex">
                                <a href="/doctor-sched/edit/<?php echo e($sched_item->id); ?>?hospital_id=<?= $_GET['hospital_id'] ?>" class="btn btn-sm btn-info">
                                    <i class="fa fa-edit"></i>
                                </a>
                                &nbsp;
                                <form action="/doctor-sched" method="post">
                                    <?php echo csrf_field(); ?>
                                    <?php echo method_field('DELETE'); ?>
                                    <input type="hidden" name="sched_id" value="<?php echo e($sched_item->id); ?>">
                                    <button type="submit" class="btn btn-sm btn-danger">
                                        <i class="fa fa-trash"></i>
                                    </button>
                                </form>
                            </div>
                        </td>
                    </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                    <tr>
                        <td colspan="6" class="text-center text-muted">No schedule found for this month.</td>
                    </tr>
                <?php endif; ?>
            </tbody>
        </table>
    </div>

</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('script'); ?>
    <script>
        $(function(){
            //Initialize Select2 Elements
            $('.select2').select2()
        })
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/misnegros/public_html/staging-onehospital/resources/views/hospitals/doc_sched/create.blade.php ENDPATH**/ ?>