<?php $__env->startSection('bread-crumb'); ?>
    <div class="row mb-2">
        <div class="col-sm-6">
        <h1>Patients</h1>
        </div>
        <div class="col-sm-6">
        <ol class="breadcrumb float-sm-right">
            <li class="breadcrumb-item active">Patients</li>
        </ol>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<div class="card card-info">
    <div class="card-header">
        
        <button type="button" class="btn btn-light" data-toggle="modal" data-target="#searchPatient">
            <i class="fa fa-search"></i> Search Patient
        </button>

        <div class="modal fade" id="searchPatient" tabindex="-1" role="dialog" aria-labelledby="searchPatientTitle" aria-hidden="true" data-backdrop="static">
            <div class="modal-dialog modal-dialog-centered" role="document">
                <div class="modal-content form">
                    <div id="searchLoading" class="overlay d-none justify-content-center align-items-center">
                        <i class="fas fa-2x fa-sync fa-spin"></i>
                    </div>
                    <div class="modal-body mb-3">
                        <h4 class="lead text-center text-dark">SEARCH FOR PATIENT</h4>
                        
                        <form id="searchForm" method="post">
                            <?php echo csrf_field(); ?>
                            <input type="text" name="search" class="form-control form-control-lg" placeholder="e.g Juan dela Cruz" auto-focus='true'>
                        
                    </div>
                    <div class="modal-footer justify-content-center">
                        <button type="submit" class="btn btn-sm btn-success"><i class="fa fa-search"></i> SEARCH</button>
                        <button type="button" class="btn btn-sm btn-default" data-dismiss="modal">Close</button>
                        </form>
                    </div>
                </div>
                <div class="modal-content result d-none text-dark">
                    <div class="modal-body">
                        <button type="button" class="close mb-2" data-dismiss="modal" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                        <table class="table" id="resultsTable">
                            <tbody></tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>

        <small class="float-right">Data as of [ <?php echo e(date('Y-m-d')); ?> ]</small>
    </div>


    <div class="card-body table-responsive">
        <h5 class="text-muted font-italic">Total of <?php echo e($patients->total()); ?> patient(s)</h5>
        <hr>
        <table id="tbl_patients" class="table table-hover text-nowrap text-uppercase">
            <thead>
                <tr>
                    <th>Type</th>
                    <th>Patient</th>
                    <th>Age</th>
                    <th>Gender</th>
                    <th>Address</th>
                    <th>Date Encoded</th>
                    <th></th>
                </tr>
            </thead>
            <tbody>

                <?php $__currentLoopData = $patients; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $p): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr>
                        <td><?php echo e($p->referral_type); ?></td>
                        <td><?php echo e($p->patient); ?></td>
                        <td><?php echo e($p->age); ?></td>
                        <td><?php echo e($p->sex); ?></td>
                        <td><?php echo e($p->address); ?></td>
                        <td><?php echo e($p->created_at); ?></td>
                        <td>
                            <a href="/referral/<?php echo e($p->id); ?>">
                                <i class="fa fa-file"></i>
                            </a>
                        </td>
                    </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

            </tbody>
        </table>

        <div class="mt-3">
            <?php echo e($patients->links()); ?>

        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('script'); ?>
    <script>
        $(function () {
            $('#searchPatient').on('hidden.bs.modal', function (e) {
                $('.form').removeClass('d-none')
                $('.result').addClass('d-none')
                searchForm.reset()
            })

            searchForm.onsubmit = async (e) => {
                e.preventDefault();
                try {
                    $('#searchLoading').removeClass('d-none').addClass('d-flex')

                    let response = await fetch('/patients/search', {
                        method: 'POST',
                        body: new FormData(searchForm)
                    });

                    let result = await response.json();

                    if(result.length > 0) {
                        let output = '';
                        result.forEach(patient => {
                            let row = '<tr><td><a href="/referral/'+patient.id+'" class="text-dark"><span class="text-uppercase text-primary">'+patient.patient+'</span> - '+patient.age+', '+patient.sex+', '+patient.address+'</a></td></tr>'
                            output+=row
                        });
                        $('#resultsTable tbody').empty().html(output)
                    } else {
                        $('#resultsTable tbody').empty().html('<tr><td class="font-italic text-center border-0"><h3 class="m-0 p-0">No record found.</h3></td></tr>')
                    }
                    
                }
                finally{
                    $('#searchLoading').removeClass('d-flex').addClass('d-none')
                    $('.form').addClass('d-none')
                    $('.result').removeClass('d-none')
                }
            };
        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/misnegros/public_html/staging-onehospital/resources/views/patient/index.blade.php ENDPATH**/ ?>