<?php $__env->startSection('bread-crumb'); ?>
    <div class="row mb-2">
        <div class="col-sm-6">
        <h1>Reports</h1>
        </div>
        <div class="col-sm-6">
        <ol class="breadcrumb float-sm-right">
            <li class="breadcrumb-item"><a href="/dashboard">Dashboard</a></li>
            <li class="breadcrumb-item active">Reports</li>
        </ol>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <div class="row">
        <div class="col-12 col-sm-6 col-md-3">
            <div class="info-box">
                <span class="info-box-icon bg-info elevation-1"><i class="fas fa-procedures"></i></span>

                <div class="info-box-content">
                    <span class="info-box-text">Total Encoded Patients</span>
                    <span class="info-box-number">
                        <?php echo e($p_total); ?>

                    </span>
                </div>
            </div>
        </div>

        <div class="col-12 col-sm-6 col-md-3">
            <div class="info-box">
                <span class="info-box-icon bg-info elevation-1"><i class="fas fa-address-card"></i></span>

                <div class="info-box-content">
                    <span class="info-box-text">Total Created Referrals</span>
                    <span class="info-box-number">
                        <?php echo e($ref_total); ?>

                    </span>
                </div>
            </div>
        </div>

        <div class="col-12 col-sm-6 col-md-3">
            <div class="info-box">
                <span class="info-box-icon bg-info elevation-1"><i class="fas fa-clipboard-list"></i></span>

                <div class="info-box-content">
                    <span class="info-box-text">Total Created Referrals by LGU</span>
                    <span class="info-box-number">
                        <?php echo e($lgu_total); ?>

                    </span>
                </div>
            </div>
        </div>

        <div class="col-12 col-sm-6 col-md-3">
            <div class="info-box">
                <span class="info-box-icon bg-info elevation-1"><i class="fas fa-h-square"></i></span>

                <div class="info-box-content">
                    <span class="info-box-text">Total Created Referrals by Hospital</span>
                    <span class="info-box-number">
                        <?php echo e($hosps_total); ?>

                    </span>
                </div>
            </div>
        </div>





        <div class="col-12 col-sm-6 col-md-6">
            <div class="card card-primary card-outline">
                <div class="card-body table-responsive p-0">
                    <table id="hospital_table" class="table table-hover text-nowrap">
                        <thead>
                            <th>HOSPITAL [<?php echo e(count($hosp)); ?>]</th>
                            <th>TOTAL REFERRALS</th>
                        </thead>
                        <tbody>
                            <?php $__currentLoopData = $hosp; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td><?php echo e($item); ?></td>
                                    <td><?php echo e($value); ?></td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>

        <div class="col-12 col-sm-6 col-md-6">
            <div id="hospital_chart" width="100%" height="100%"></div>
        </div>

        <div class="col-12 col-sm-6 col-md-6">
            <div class="card card-primary card-outline">
                <div class="card-body table-responsive p-0">
                    <table id="lgu_table" class="table table-hover text-nowrap">
                        <thead>
                            <th>LGU [<?php echo e(count($lgu)); ?>]</th>
                            <th>TOTAL REFERRALS</th>
                        </thead>
                        <tbody>
                            <?php $__currentLoopData = $lgu; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td><?php echo e($item); ?></td>
                                    <td><?php echo e($value); ?></td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>

        <div class="col-12 col-sm-6 col-md-6">
            <div id="lgu_chart" width="100%" height="100%"></div>
        </div>


    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('script'); ?>
    <script>
        $(function () {
            $("#hospital_table").DataTable({
                "responsive": false, "lengthChange": false, "autoWidth": false, "paging": true, "searching": false, "info": false,
                // "buttons": ["csv"]
            }).buttons().container().appendTo('#hospital_table_wrapper .col-md-6:eq(0)');

            $("#lgu_table").DataTable({
                "responsive": false, "lengthChange": false, "autoWidth": false, "paging": true, "searching": false, "info": false,
                // "buttons": ["csv"]
            }).buttons().container().appendTo('#hospital_table_wrapper .col-md-6:eq(0)');

            var labels = []
            <?php $__currentLoopData = $hosp; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                labels.push({ label: '<?php echo e($item); ?>', y: <?php echo e($value); ?> })
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

            var options = {
                title: {
                    text: "Created Referrals by Hospital"
                },
                data: [{
                        type: "pie",
                        startAngle: 45,
                        showInLegend: "true",
                        legendText: "{label}",
                        indexLabel: "{label} ({y})",
                        yValueFormatString:"#,##0.#"%"",
                        dataPoints: labels
                }]
            };
            $("#hospital_chart").CanvasJSChart(options);

            var labels = []
            <?php $__currentLoopData = $lgu; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                labels.push({ label: '<?php echo e($item); ?>', y: <?php echo e($value); ?> })
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

            var options = {
                title: {
                    text: "Created Referrals by LGU"
                },
                data: [{
                        type: "pie",
                        startAngle: 45,
                        showInLegend: "true",
                        legendText: "{label}",
                        indexLabel: "{label} ({y})",
                        yValueFormatString:"#,##0.#"%"",
                        dataPoints: labels
                }]
            };
            $("#lgu_chart").CanvasJSChart(options);
        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/misnegros/public_html/staging-onehospital/resources/views/report/index.blade.php ENDPATH**/ ?>