<?php $__env->startSection('bread-crumb'); ?>
    <div class="row mb-2">
        <div class="col-sm-6">
        <h1>REF # <?php echo e($referral->referral_no); ?> </h1>
        </div>
        <div class="col-sm-6">
        <ol class="breadcrumb float-sm-right">
            <li class="breadcrumb-item"><a href="/dashboard">Dashboard</a></li>
            <li class="breadcrumb-item"><a href="/referrals">Referrals</a></li>
            <li class="breadcrumb-item active">REF # <?php echo e($referral->referral_no); ?></li>
        </ol>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<div class="card card-info">
    <div class="card-header">
        <h3 class="card-title">Created by: <?php echo e(ucfirst(Auth::user()->fname)); ?> <?php echo e(ucfirst(Auth::user()->lname)); ?></h3>
    </div>
    <form class="form-horizontal" method="POST" action="/referral/<?php echo e($referral->id); ?>">
        <?php echo method_field('PUT'); ?>
        <?php echo csrf_field(); ?>
        <div class="card-body p-5">
            <h3 class="text-center mb-5">REF # <?php echo e($referral->referral_no); ?></h3>

            <?php if($errors->any()): ?>
                <div class="alert alert-danger">
                    <ul>
                        <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <li><?php echo e($error); ?></li>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </ul>
                </div>
            <?php endif; ?>

            <?php if(session()->has('referral.update')): ?>
                <?php if(session()->get('referral.update')): ?>
                    <div class="alert alert-success alert-dismissible col-12" id="alert">
                        <button type="button" class="close" data-dismiss="alert" aria-hidden="true">&times;</button>
                        <h5><i class="icon fas fa-check"></i> Success!</h5>
                        REF # <?php echo e($referral->referral_no); ?> successfully sent to selected hospital!
                    </div>
                <?php endif; ?>
            <?php endif; ?>

            <?php if($referral->ref_to_hospital == null): ?>
                <div class="form-group row">
                    <label for="ref_from_hospital" class="col-sm-2 col-form-label">REFER TO *</label>
                    <div class="col-sm-10">
                        <select class="form-control select2" name="ref_to_hospital" style="width: 100%;" required>
                            <option selected="selected" value="">Please select a hospital</option>
                            <?php $__currentLoopData = $hospitals; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <?php if($item->id != $referral->ref_from_hospital): ?>
                                    <option value="<?php echo e($item->id); ?>" <?php if($item->id == old('ref_to_hospital')): ?> selected <?php endif; ?> class="text-capitalize"> <?php echo e($item->hospital); ?> </option>
                                <?php endif; ?>

                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>

                        <?php $__errorArgs = ['ref_from_hospital'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <span>
                                <?php echo e($message); ?>

                            </span>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>
                </div>
            <?php else: ?>
                <div class="form-group row">
                    <label for="ref_from_hospital" class="col-sm-2 col-form-label">REFERRED TO </label>
                    <div class="col-sm-10">
                        <?php $__currentLoopData = $hospitals; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <?php if($item->id == $referral->ref_to_hospital): ?>
                                <input type="text" class="form-control" value=" <?php echo e($item->hospital); ?> " readonly  >
                            <?php endif; ?>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>
                </div>
            <?php endif; ?>

            <div class="form-group row">
                <label for="ref_from_hospital" class="col-sm-2 col-form-label">REFERRED FROM </label>
                <div class="col-sm-10">
                    <?php $__currentLoopData = $hospitals; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <?php if($item->id == $referral->ref_from_hospital): ?>
                            <input type="text" class="form-control text-capitalize" value=" <?php echo e($item->hospital); ?> " readonly  >
                        <?php endif; ?>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
            </div>



            <div class="form-group row">
                <label for="patient_name" class="col-sm-2 col-form-label">PATIENT NAME</label>
                <div class="col-sm-10">
                    <input type="text" class="form-control text-capitalize" value=" <?php echo e($referral->patient); ?> " readonly  >
                </div>
            </div>

            <div class="form-group row">
                <label for="age" class="col-sm-2 col-form-label">AGE</label>
                <div class="col-sm-10">
                    <input type="text" class="form-control" value=" <?php echo e($referral->age); ?> " readonly  >
                </div>
            </div>

            <div class="form-group row">
                <label for="sex" class="col-sm-2 col-form-label">SEX</label>
                <div class="col-sm-10">
                    <input type="text" class="form-control text-capitalize" value=" <?php echo e($referral->sex); ?> " readonly  >
                </div>
            </div>

            <div class="form-group row">
                <label for="birthdata" class="col-sm-2 col-form-label">BIRTHDATE</label>
                <div class="col-sm-10">
                    <?php $date=date_create($referral->birthdate) ?>
                    <input type="text" class="form-control" value=" <?php echo e(date_format($date,"Y/m/d")); ?> " readonly  >
                </div>
            </div>

            <div class="form-group row">
                <label for="civil_status" class="col-sm-2 col-form-label">CIVIL STATUS</label>
                <div class="col-sm-10">
                    <input type="text" class="form-control  text-capitalize" value=" <?php echo e($referral->civil_status); ?> " readonly  >
                </div>
            </div>

            <div class="form-group row">
                <label for="address" class="col-sm-2 col-form-label">ADDRESS</label>
                <div class="col-sm-10">
                    <input type="text" class="form-control text-capitalize" value=" <?php echo e($referral->address); ?> " readonly  >
                </div>
            </div>

            <div class="form-group row">
                <label for="occupation" class="col-sm-2 col-form-label">OCCUPATION</label>
                <div class="col-sm-10">
                    <input type="text" class="form-control text-capitalize" value=" <?php echo e($referral->occupation); ?> " readonly  >
                </div>
            </div>

            <div class="form-group row">
                <label for="religion" class="col-sm-2 col-form-label">RELIGION</label>
                <div class="col-sm-10">
                    <input type="text" class="form-control" value=" <?php echo e($referral->religion); ?> " readonly  >
                </div>
            </div>

            <div class="form-group row">
                <label for="guardian" class="col-sm-2 col-form-label">GUARDIAN</label>
                <div class="col-sm-10">
                    <input type="text" class="form-control text-capitalize" value=" <?php echo e($referral->guardian); ?> " readonly  >
                </div>
            </div>

            <div class="form-group row">
                <label for="" class="col-sm-2 col-form-label"></label>
                <div class="col-sm-10">
                    <div class="form-group clearfix">
                        <div class="icheck-success d-inline mr-3">
                            <input type="radio" readonly <?php if($referral->state == 'pwd'): ?> checked <?php endif; ?>>
                            <label for="state1">
                                PWD
                            </label>
                        </div>
                        <div class="icheck-success d-inline mr-3">
                            <input type="radio" readonly <?php if($referral->state == 'sc'): ?> checked <?php endif; ?>>
                            <label for="state2">
                                SC
                            </label>
                        </div>
                        <div class="icheck-success d-inline">
                            <input type="radio" readonly <?php if($referral->state == 'ic'): ?> checked <?php endif; ?>>
                            <label for="state3">
                                IC
                            </label>
                        </div>
                      </div>
                </div>
            </div>

            <div class="form-group row">
                <label class="col-sm-2 col-form-label">CHIEF COMPLAINT</label>
                <div class="col-sm-10">
                    <textarea class="form-control" rows="5" readonly  ><?php echo e($referral->complaint); ?></textarea>
                </div>
            </div>

            <div class="form-group row">
                <label for="inputPassword3" class="col-sm-2 col-form-label">VITAL SIGNS</label>
                <div class="col-sm-10 row">
                    <div class="col-sm-4">
                        <div class="form-group">
                            <label class="font-weight-normal">BP</label>
                            <input type="text" class="form-control form-control-sm" readonly value="<?php echo e($referral->vs_bp); ?>"  >
                        </div>
                    </div>

                    <div class="col-sm-4">
                        <div class="form-group">
                            <label class="font-weight-normal">HR</label>
                            <input type="text" class="form-control form-control-sm" readonly value="<?php echo e($referral->vs_hr); ?>"  >
                        </div>
                    </div>

                    <div class="col-sm-4">
                        <div class="form-group">
                            <label class="font-weight-normal">RR</label>
                            <input type="text" class="form-control form-control-sm" readonly value="<?php echo e($referral->vs_rr); ?>"  >
                        </div>
                    </div>

                    <div class="col-sm-4">
                        <div class="form-group">
                            <label class="font-weight-normal">TEMP</label>
                            <input type="text" class="form-control form-control-sm" readonly value="<?php echo e($referral->vs_temp); ?>"  >
                        </div>
                    </div>

                    <div class="col-sm-4">
                        <div class="form-group">
                            <label class="font-weight-normal">WEIGHT</label>
                            <input type="text" class="form-control form-control-sm" readonly value="<?php echo e($referral->vs_weight); ?>"  >
                        </div>
                    </div>
                </div>
            </div>

            <div class="form-group row bg-warning">
                <label for="inputPassword3" class="col-sm-2 col-form-label">NEW VITAL SIGNS</label>
                <div class="col-sm-10 row">
                    <div class="col-sm-4">
                        <div class="form-group">
                            <label class="font-weight-normal">BP</label>
                            <input type="text" class="form-control form-control-sm" name="vs_bp" value="<?php echo e(old('vs_bp')); ?>" placeholder="-">
                        </div>
                    </div>

                    <div class="col-sm-4">
                        <div class="form-group">
                            <label class="font-weight-normal">HR</label>
                            <input type="text" class="form-control form-control-sm" name="vs_hr" value="<?php echo e(old('vs_hr')); ?>" placeholder="-">
                        </div>
                    </div>

                    <div class="col-sm-4">
                        <div class="form-group">
                            <label class="font-weight-normal">RR</label>
                            <input type="text" class="form-control form-control-sm" name="vs_rr" value="<?php echo e(old('vs_rr')); ?>" placeholder="-">
                        </div>
                    </div>

                    <div class="col-sm-4">
                        <div class="form-group">
                            <label class="font-weight-normal">TEMP</label>
                            <input type="text" class="form-control form-control-sm" name="vs_temp" value="<?php echo e(old('vs_temp')); ?>" placeholder="-">
                        </div>
                    </div>

                    <div class="col-sm-4">
                        <div class="form-group">
                            <label class="font-weight-normal">WEIGHT</label>
                            <input type="text" class="form-control form-control-sm" name="vs_weight" value="<?php echo e(old('vs_weight')); ?>" placeholder="-">
                        </div>
                    </div>
                </div>
            </div>

            <div class="form-group row">
                <label for="inputPassword3" class="col-sm-2 col-form-label">OB HISTORY</label>
                <div class="col-sm-10 row">
                    <div class="col-sm-4">
                        <div class="form-group">
                            <label class="font-weight-normal">G</label>
                            <input type="text" class="form-control form-control-sm" readonly value="<?php echo e($referral->obh_g); ?>"  >
                        </div>
                    </div>

                    <div class="col-sm-4">
                        <div class="form-group">
                            <label class="font-weight-normal">P</label>
                            <input type="text" class="form-control form-control-sm" readonly value="<?php echo e($referral->obh_p); ?>"  >
                        </div>
                    </div>

                    <div class="col-sm-4">
                        <div class="form-group">
                            <label class="font-weight-normal">LMP</label>
                            <input type="text" class="form-control form-control-sm" readonly value="<?php echo e($referral->obh_lmp); ?>"  >
                        </div>
                    </div>

                    <div class="col-sm-4">
                        <div class="form-group">
                            <label class="font-weight-normal">EDC</label>
                            <input type="text" class="form-control form-control-sm" readonly value="<?php echo e($referral->obh_edc); ?>"  >
                        </div>
                    </div>

                    <div class="col-sm-4">
                        <div class="form-group">
                            <label class="font-weight-normal">AOG</label>
                            <input type="text" class="form-control form-control-sm" readonly value="<?php echo e($referral->obh_aog); ?>"  >
                        </div>
                    </div>

                    <div class="col-sm-4">
                        <div class="form-group">
                            <label class="font-weight-normal">FH</label>
                            <input type="text" class="form-control form-control-sm" readonly value="<?php echo e($referral->obh_fh); ?>"  >
                        </div>
                    </div>

                    <div class="col-sm-4">
                        <div class="form-group">
                            <label class="font-weight-normal">FHR</label>
                            <input type="text" class="form-control form-control-sm" readonly value="<?php echo e($referral->obh_fhr); ?>"  >
                        </div>
                    </div>

                    <div class="col-sm-4">
                        <div class="form-group">
                            <label class="font-weight-normal">PELVIC</label>
                            <input type="text" class="form-control form-control-sm" readonly value="<?php echo e($referral->obh_pelvic); ?>">
                        </div>
                    </div>
                </div>
            </div>

            <div class="form-group row bg-warning" >
                <label for="inputPassword3" class="col-sm-2 col-form-label">NEW OB HISTORY</label>
                <div class="col-sm-10 row">
                    <div class="col-sm-4">
                        <div class="form-group">
                            <label class="font-weight-normal">G</label>
                            <input type="text" class="form-control form-control-sm" name="obh_g" value="<?php echo e(old('obh_g')); ?>" placeholder="-">
                        </div>
                    </div>

                    <div class="col-sm-4">
                        <div class="form-group">
                            <label class="font-weight-normal">P</label>
                            <input type="text" class="form-control form-control-sm" name="obh_p" value="<?php echo e(old('obh_p')); ?>" placeholder="-">
                        </div>
                    </div>

                    <div class="col-sm-4">
                        <div class="form-group">
                            <label class="font-weight-normal">LMP</label>
                            <input type="text" class="form-control form-control-sm" name="obh_lmp" value="<?php echo e(old('obh_lmp')); ?>" placeholder="-">
                        </div>
                    </div>

                    <div class="col-sm-4">
                        <div class="form-group">
                            <label class="font-weight-normal">EDC</label>
                            <input type="text" class="form-control form-control-sm" name="obh_edc" value="<?php echo e(old('obh_edc')); ?>" placeholder="-">
                        </div>
                    </div>

                    <div class="col-sm-4">
                        <div class="form-group">
                            <label class="font-weight-normal">AOG</label>
                            <input type="text" class="form-control form-control-sm" name="obh_aog" value="<?php echo e(old('obh_aog')); ?>" placeholder="-">
                        </div>
                    </div>

                    <div class="col-sm-4">
                        <div class="form-group">
                            <label class="font-weight-normal">FH</label>
                            <input type="text" class="form-control form-control-sm" name="obh_fh" value="<?php echo e(old('obh_fh')); ?>" placeholder="-">
                        </div>
                    </div>

                    <div class="col-sm-4">
                        <div class="form-group">
                            <label class="font-weight-normal">FHR</label>
                            <input type="text" class="form-control form-control-sm" name="obh_fhr" value="<?php echo e(old('obh_fhr')); ?>" placeholder="-">
                        </div>
                    </div>

                    <div class="col-sm-4">
                        <div class="form-group">
                            <label class="font-weight-normal">PELVIC</label>
                            <input type="text" class="form-control form-control-sm" name="obh_pelvic" value="<?php echo e(old('obh_pelvic')); ?>" placeholder="-">
                        </div>
                    </div>
                </div>
            </div>

            <div class="form-group row">
                <label for="inputPassword3" class="col-sm-2 col-form-label">BRIEF HX & PE</label>
                <div class="col-sm-10">
                    <textarea class="form-control" rows="5" readonly  ><?php echo e($referral->hx_n_pe); ?></textarea>
                </div>
            </div>

            <div class="form-group row">
                <label for="inputPassword3" class="col-sm-2 col-form-label">IMPRESSION OR DIAGNOSIS</label>
                <div class="col-sm-10">
                    <textarea class="form-control" rows="5" readonly  ><?php echo e($referral->diagnosis); ?></textarea>
                </div>
            </div>

            <div class="form-group row">
                <label for="inputPassword3" class="col-sm-2 col-form-label">MEDICATION/TREATMENT</label>
                <div class="col-sm-10">
                    <textarea class="form-control" rows="5" readonly  ><?php echo e($referral->medication); ?></textarea>
                </div>
            </div>

            <div class="form-group row">
                <label for="inputPassword3" class="col-sm-2 col-form-label">REASON FOR REFERRAL</label>
                <div class="col-sm-10 row">
                    <div class="col-sm-4 mb-2">
                        <div class="icheck-success d-inline">
                            <input type="radio" readonly <?php if($referral->reason == 'Further evaluation and management'): ?> checked <?php endif; ?>>
                            <label for="reason1" class="font-weight-normal">
                                Further evaluation and management
                            </label>
                        </div>
                    </div>

                    <div class="col-sm-4 mb-2">
                        <div class="icheck-success d-inline">
                            <input type="radio" readonly <?php if($referral->reason == 'For Work-up'): ?> checked <?php endif; ?>>
                            <label for="reason2" class="font-weight-normal">
                                For Work-up
                            </label>
                        </div>
                    </div>

                    <div class="col-sm-4 mb-2">
                        <div class="icheck-success d-inline">
                            <input type="radio" readonly <?php if($referral->reason == 'For Medico-legal'): ?> checked <?php endif; ?>>
                            <label for="reason3" class="font-weight-normal">
                                For Medico-legal
                            </label>
                        </div>
                    </div>

                    <div class="col-sm-4 mb-2">
                        <div class="icheck-success d-inline">
                            <input type="radio" readonly <?php if($referral->reason == 'Isolation'): ?> checked <?php endif; ?>>
                            <label for="reason4" class="font-weight-normal">
                                Isolation
                            </label>
                        </div>
                    </div>

                    <div class="col-sm-4 mb-2">
                        <div class="icheck-success d-inline">
                            <input type="radio" readonly <?php if($referral->reason == "Patient's Request"): ?> checked <?php endif; ?>>
                            <label for="reason5" class="font-weight-normal">
                                Patient's Request
                            </label>
                        </div>
                    </div>

                    <div class="col-sm-4 mb-2">
                        <div class="icheck-success d-inline">
                            <input type="radio" name="reason" readonly <?php if($referral->reason == 'OPD Consult'): ?> checked <?php endif; ?>>
                            <label for="reason6" class="font-weight-normal">
                                OPD Consult
                            </label>
                        </div>
                    </div>

                    
                    <?php $__errorArgs = ['reason'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                        <span>
                            <?php echo e($message); ?>

                        </span>
                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                </div>
            </div>

            <div class="form-group row">
                <label class="col-sm-2 col-form-label">PHIC ID NO.</label>
                <div class="col-sm-10">
                    <input type="text" class="form-control" value="<?php echo e($referral->phic_id_no); ?>" readonly  >
                </div>
            </div>

            <div class="form-group row">
                <label for="inputPassword3" class="col-sm-2 col-form-label">REFERRED BY</label>
                <div class="col-sm-10">
                    <input type="text" class="form-control text-capitalize" value="<?php echo e($referral->ref_by); ?>" readonly  >
                </div>
            </div>

            <div class="form-group row mb-4">
                <label for="inputPassword3" class="col-sm-2 col-form-label">CONTACT NO.</label>
                <div class="col-sm-10">
                    <input type="text" class="form-control" value="<?php echo e($referral->contact_no); ?>" readonly  >
                </div>
            </div>

            <?php if(Auth::user()->role == 1): ?>
                <hr>
                <div class="form-group row mb-4">
                    <label for="inputPassword3" class="col-sm-2 col-form-label">ROOM DETAILS</label>
                    <div class="col-sm-10 mt-2">
                        <?php echo e($station->station); ?> - <?php echo e($room->room); ?> - <?php echo e($bed->bed); ?>

                        <a class="float-right text-decoration-none text-dark font-italic" href="/hospital/<?php echo e(Auth::user()->hospital_id); ?>/station/<?php echo e($patient->station_id); ?>/room/<?php echo e($patient->room_id); ?>/bed" target="_blank" rel="noopener noreferrer">
                            View Bed
                        </a>
                    </div>
                </div>
            <?php endif; ?>



        </div>

        <div class="card-footer justify-content-center text-center">
            <button type="submit" class="btn btn-info">UPDATE</button>
            <a href="/referrals" class="btn btn-default">CANCEL</a>
        </div>



    </form>


</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('script'); ?>
    <script>
        $(function () {
            //Initialize Select2 Elements
            $('.select2').select2()
        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/misnegros/public_html/staging-onehospital/resources/views/patient/create.blade.php ENDPATH**/ ?>