<?php $__env->startSection('bread-crumb'); ?>
    <div class="row mb-2">
        <div class="col-sm-6">
        <h1>Create Referral</h1>
        </div>
        <div class="col-sm-6">
        <ol class="breadcrumb float-sm-right">
            <li class="breadcrumb-item"><a href="/dashboard">Dashboard</a></li>
            <li class="breadcrumb-item"><a href="/referrals">Referrals</a></li>
            <li class="breadcrumb-item active">Create Referral</li>
        </ol>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<div class="card card-success card-outline card-tabs">



    <?php if(Auth::user()->role == 2): ?>
        <form class="form-horizontal" method="POST" action="/referral/direct_refer" enctype="multipart/form-data">
    <?php else: ?>
        <?php if(isset($_GET['internal'])): ?>
            <form class="form-horizontal" method="POST" action="/patient/walkin" enctype="multipart/form-data">
        <?php else: ?>
            <?php if(Auth::user()->role == 1): ?>
                <div class="card-header">
                    <a href="/print-blank-referral" class="btn btn-danger" title="Print blank referral form">
                        <i class="fa fa-print"></i> PRINT
                    </a>
                </div>
            <?php endif; ?>
            <form class="form-horizontal" method="POST" action="/referral" enctype="multipart/form-data">
        <?php endif; ?>
    <?php endif; ?>

        <?php echo csrf_field(); ?>
        <div class="card-body p-5">
            <h3 class="text-center">HEALTH REFERRAL FORM</h3>
            <?php if(isset($_GET['internal'])): ?>
                <h5 class="text-center mb-5 text-muted font-italic">-ADD PATIENT DETAILS-</h5>
            <?php endif; ?>

            <?php if($errors->any()): ?>
                <div class="alert alert-danger">
                    <ul>
                        <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <li><?php echo e($error); ?></li>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </ul>
                </div>
            <?php endif; ?>

            <?php if(session()->has('referral.store')): ?>
                <?php if(session()->get('referral.store')): ?>
                    <div class="alert alert-success alert-dismissible col-12" id="alert">
                        <button type="button" class="close" data-dismiss="alert" aria-hidden="true">&times;</button>
                        <h5><i class="icon fas fa-check"></i> Success!</h5>
                        New referral successfully added
                    </div>
                <?php endif; ?>
            <?php endif; ?>

            <?php if(Auth::user()->role == 1): ?>


                <?php if(isset($_GET['internal'])): ?>
                    <?php if(isset($_GET['bed_id'])): ?>
                        <div class="form-group row">
                            <label for="ref_from_hospital" class="col-sm-2 col-form-label">BED DETAILS</label>
                            <div class="col-sm-10">
                                <input type="text" class="form-control font-italic text-uppercase" value="<?php echo e($station->station); ?> | <?php echo e($room->room); ?> | <?php echo e($bed->bed); ?>" readonly>
                                <input type="hidden" name="bed_id" value="<?php echo e($bed->id); ?>">
                            </div>
                        </div>
                    <?php else: ?>
                        <div class="form-group row">
                            <label for="ref_from_hospital" class="col-sm-2 col-form-label">BED DETAILS</label>
                            <div class="col-sm-10">
                                <input type="text" class="form-control font-italic text-uppercase" value="<?php echo e($dept_bed->type); ?> | <?php echo e($dept_bed->bed); ?> | <?php echo e($dept_bed->description); ?>" readonly>
                                <input type="hidden" name="dept_bed_id" value="<?php echo e($dept_bed->id); ?>">
                            </div>
                        </div>
                    <?php endif; ?>
                <?php else: ?>
                    <div class="form-group row">
                        <label for="ref_from_hospital" class="col-sm-2 col-form-label">REFERRING HOSPITAL</label>
                        <div class="col-sm-10">
                            <input type="hidden" class="form-control" id="ref_from_hospital" name="ref_from_hospital" value="<?php echo e($hospital->id); ?>">
                            <input type="text" class="form-control" value="<?php echo e($hospital->hospital); ?>" readonly>
                        </div>
                    </div>
                <?php endif; ?>
            <?php endif; ?>

            <?php if(Auth::user()->role == 4): ?>
                <div class="form-group row">
                    <label for="ref_from_hospital" class="col-sm-2 col-form-label">REFERRING CITY/MUNICIPALITY</label>
                    <div class="col-sm-10">
                        <input type="hidden" class="form-control" id="ref_from_drrmo" name="ref_from_drrmo" value="<?php echo e($drrmo->id); ?>">
                        <input type="text" class="form-control" value="<?php echo e($drrmo->drrmo); ?>" readonly>
                    </div>
                </div>
            <?php endif; ?>

            <?php if(Auth::user()->role == 2): ?>
                <input type="hidden" class="form-control" id="ref_to_hospital" name="ref_to_hospital" value="<?= $_GET['hospital_id'] ?>">

                <?php
                    $bed_id = isset($_GET['bed_id']);
                ?>
                <?php if($bed_id): ?>
                    <input type="hidden" class="form-control" id="bed_id" name="bed_id" value="<?= $_GET['bed_id'] ?>">
                <?php else: ?>
                    <input type="hidden" class="form-control" id="dept_bed_id" name="dept_bed_id" value="<?= $_GET['dept_bed_id'] ?>">
                <?php endif; ?>
            <?php endif; ?>

            <div class="form-group row">
                <label for="patient_name" class="col-sm-2 col-form-label">PATIENT NAME *</label>
                <div class="col-sm-10">
                    <input type="text" class="form-control" id="patient" name="patient" value="<?php echo e(old('patient')); ?>" placeholder="-" required>
                    <?php $__errorArgs = ['patient'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                        <span>
                            <?php echo e($message); ?>

                        </span>
                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                </div>
            </div>

            <div class="form-group row">
                <label for="birthdate" class="col-sm-2 col-form-label">BIRTHDATE *</label>
                <div class="col-sm-10">
                    <input type="date" class="form-control" name="birthdate" id="birthdate" value="<?php echo e(old('birthdate')); ?>" required>
                </div>
            </div>

            <div class="form-group row">
                <label for="age" class="col-sm-2 col-form-label">AGE</label>
                <div class="col-sm-10">
                    <input type="text" class="form-control" name="age" id="age" value="<?php echo e(old('age')); ?>" placeholder="-" readonly>
                    <?php $__errorArgs = ['age'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                        <span>
                            <?php echo e($message); ?>

                        </span>
                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                </div>
            </div>

            <div class="form-group row">
                <label for="sex" class="col-sm-2 col-form-label">SEX *</label>
                <div class="col-sm-10">
                    <select class="form-control select2" name="sex" style="width: 100%;" required>
                        <option selected="selected" value="">Please select a sex</option>
                        <option value="male" <?php if(old('sex') == 'male'): ?> selected <?php endif; ?>>Male</option>
                        <option value="female" <?php if(old('sex') == 'female'): ?> selected <?php endif; ?>>Female</option>
                    </select>
                    <?php $__errorArgs = ['sex'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                        <span>
                            <?php echo e($message); ?>

                        </span>
                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                </div>
            </div>

            <div class="form-group row">
                <label for="civil_status" class="col-sm-2 col-form-label">CIVIL STATUS</label>
                <div class="col-sm-10">
                    <select class="form-control select2" name="civil_status" style="width: 100%;">
                        <option selected="selected" value="">Please select a civil status</option>
                        <option value="single">Single</option>
                        <option value="married">Married</option>
                        <option value="separated">Separated</option>
                        <option value="divorced">Divorce</option>
                        <option value="widowed">Widowed</option>
                    </select>
                </div>
            </div>

            <div class="form-group row">
                <label for="address" class="col-sm-2 col-form-label">ADDRESS *</label>
                <div class="col-sm-10">
                    <input type="text" class="form-control" name="address" value="<?php echo e(old('address')); ?>" placeholder="-" required>
                    <?php $__errorArgs = ['address'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                        <span>
                            <?php echo e($message); ?>

                        </span>
                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                </div>
            </div>

            <div class="form-group row">
                <label for="occupation" class="col-sm-2 col-form-label">OCCUPATION</label>
                <div class="col-sm-10">
                    <input type="text" class="form-control" name="occupation" placeholder="-">
                </div>
            </div>

            <div class="form-group row">
                <label for="religion" class="col-sm-2 col-form-label">RELIGION</label>
                <div class="col-sm-10">
                    <input type="text" class="form-control" name="religion" placeholder="-">
                </div>
            </div>

            <div class="form-group row">
                <label for="guardian" class="col-sm-2 col-form-label">GUARDIAN *</label>
                <div class="col-sm-10">
                    <input type="text" class="form-control" name="guardian" value="<?php echo e(old('guardian')); ?>" placeholder="-" required>
                    <?php $__errorArgs = ['guardian'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                        <span>
                            <?php echo e($message); ?>

                        </span>
                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                </div>
            </div>

            <div class="form-group row">
                <label for="" class="col-sm-2 col-form-label"></label>
                <div class="col-sm-10">
                    <div class="form-group clearfix">
                        <div class="icheck-success d-inline mr-3">
                            <input type="radio" name="state" id="state1" value="pwd">
                            <label for="state1">
                                PWD
                            </label>
                        </div>
                        <div class="icheck-success d-inline mr-3">
                            <input type="radio" name="state" id="state2" value="sc">
                            <label for="state2">
                                SC
                            </label>
                        </div>
                        <div class="icheck-success d-inline">
                            <input type="radio" name="state" id="state3" value="ic">
                            <label for="state3">
                                IC
                            </label>
                        </div>
                      </div>
                </div>
            </div>

            <div class="form-group row">
                <label class="col-sm-2 col-form-label">CHIEF COMPLAINT *</label>
                <div class="col-sm-10">
                    <textarea class="form-control" rows="3" name="complaint" placeholder="-" required><?php echo e(old('complaint')); ?></textarea>
                    <?php $__errorArgs = ['complaint'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                        <span>
                            <?php echo e($message); ?>

                        </span>
                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                </div>
            </div>

            <div class="form-group row">
                <label for="inputPassword3" class="col-sm-2 col-form-label">VITAL SIGNS</label>
                <div class="col-sm-10 row">
                    <div class="col-sm-4">
                        <div class="form-group">
                            <label class="font-weight-normal">BP</label>
                            <input type="text" class="form-control form-control-sm" name="vs_bp" value="<?php echo e(old('vs_bp')); ?>" placeholder="-">
                        </div>
                    </div>

                    <div class="col-sm-4">
                        <div class="form-group">
                            <label class="font-weight-normal">HR</label>
                            <input type="text" class="form-control form-control-sm" name="vs_hr" value="<?php echo e(old('vs_hr')); ?>" placeholder="-">
                        </div>
                    </div>

                    <div class="col-sm-4">
                        <div class="form-group">
                            <label class="font-weight-normal">RR</label>
                            <input type="text" class="form-control form-control-sm" name="vs_rr" value="<?php echo e(old('vs_rr')); ?>" placeholder="-">
                        </div>
                    </div>

                    <div class="col-sm-4">
                        <div class="form-group">
                            <label class="font-weight-normal">TEMP</label>
                            <input type="text" class="form-control form-control-sm" name="vs_temp" value="<?php echo e(old('vs_temp')); ?>" placeholder="-">
                        </div>
                    </div>

                    <div class="col-sm-4">
                        <div class="form-group">
                            <label class="font-weight-normal">WEIGHT</label>
                            <input type="text" class="form-control form-control-sm" name="vs_weight" value="<?php echo e(old('vs_weight')); ?>" placeholder="-">
                        </div>
                    </div>
                </div>
            </div>

            <div class="form-group row">
                <label for="inputPassword3" class="col-sm-2 col-form-label">OB HISTORY</label>
                <div class="col-sm-10 row">
                    <div class="col-sm-4">
                        <div class="form-group">
                            <label class="font-weight-normal">G</label>
                            <input type="text" class="form-control form-control-sm" name="obh_g" value="<?php echo e(old('obh_g')); ?>" placeholder="-">
                        </div>
                    </div>

                    <div class="col-sm-4">
                        <div class="form-group">
                            <label class="font-weight-normal">P</label>
                            <input type="text" class="form-control form-control-sm" name="obh_p" value="<?php echo e(old('obh_p')); ?>" placeholder="-">
                        </div>
                    </div>

                    <div class="col-sm-4">
                        <div class="form-group">
                            <label class="font-weight-normal">LMP</label>
                            <input type="text" class="form-control form-control-sm" name="obh_lmp" value="<?php echo e(old('obh_lmp')); ?>" placeholder="-">
                        </div>
                    </div>

                    <div class="col-sm-4">
                        <div class="form-group">
                            <label class="font-weight-normal">EDC</label>
                            <input type="text" class="form-control form-control-sm" name="obh_edc" value="<?php echo e(old('obh_edc')); ?>" placeholder="-">
                        </div>
                    </div>

                    <div class="col-sm-4">
                        <div class="form-group">
                            <label class="font-weight-normal">AOG</label>
                            <input type="text" class="form-control form-control-sm" name="obh_aog" value="<?php echo e(old('obh_aog')); ?>" placeholder="-">
                        </div>
                    </div>

                    <div class="col-sm-4">
                        <div class="form-group">
                            <label class="font-weight-normal">FH</label>
                            <input type="text" class="form-control form-control-sm" name="obh_fh" value="<?php echo e(old('obh_fh')); ?>" placeholder="-">
                        </div>
                    </div>

                    <div class="col-sm-4">
                        <div class="form-group">
                            <label class="font-weight-normal">FHR</label>
                            <input type="text" class="form-control form-control-sm" name="obh_fhr" value="<?php echo e(old('obh_fhr')); ?>" placeholder="-">
                        </div>
                    </div>

                    <div class="col-sm-4">
                        <div class="form-group">
                            <label class="font-weight-normal">PELVIC</label>
                            <input type="text" class="form-control form-control-sm" name="obh_pelvic" value="<?php echo e(old('obh_pelvic')); ?>" placeholder="-">
                        </div>
                    </div>
                </div>
            </div>

            <div class="form-group row">
                <label for="inputPassword3" class="col-sm-2 col-form-label">BRIEF HX & PE</label>
                <div class="col-sm-10">
                    <textarea class="form-control" rows="3" name="hx_n_pe" placeholder="-"><?php echo e(old('hx_n_pe')); ?></textarea>
                </div>
            </div>

            <div class="form-group row">
                <label for="inputPassword3" class="col-sm-2 col-form-label">IMPRESSION OR DIAGNOSIS *</label>
                <div class="col-sm-10">
                    <textarea class="form-control" rows="3" name="diagnosis" placeholder="-" required><?php echo e(old('diagnosis')); ?></textarea>
                    <?php $__errorArgs = ['diagnosis'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                        <span>
                            <?php echo e($message); ?>

                        </span>
                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                </div>
            </div>

            <div class="form-group row">
                <label for="inputPassword3" class="col-sm-2 col-form-label">MEDICATION/TREATMENT</label>
                <div class="col-sm-10">
                    <textarea class="form-control" rows="3" name="medication" placeholder="-"><?php echo e(old('medication')); ?></textarea>
                </div>
            </div>

            <div class="form-group row">
                <label for="inputPassword3" class="col-sm-2 col-form-label">REASON FOR REFERRAL *</label>
                <div class="col-sm-10 row">
                    <div class="col-sm-4 mb-2">
                        <div class="icheck-success d-inline">
                            <input type="radio" name="reason" id="reason1" value="Further evaluation and management" <?php if(old('reason') == 'Further evaluation and management'): ?> checked <?php endif; ?>>
                            <label for="reason1" class="font-weight-normal">
                                Further evaluation and management
                            </label>
                        </div>
                    </div>

                    <div class="col-sm-4 mb-2">
                        <div class="icheck-success d-inline">
                            <input type="radio" name="reason" id="reason2" value="For Work-up" <?php if(old('reason') == 'For Work-up'): ?> checked <?php endif; ?>>
                            <label for="reason2" class="font-weight-normal">
                                For Work-up
                            </label>
                        </div>
                    </div>

                    <div class="col-sm-4 mb-2">
                        <div class="icheck-success d-inline">
                            <input type="radio" name="reason" id="reason3" value="For Medico-legal" <?php if(old('reason') == 'For Medico-legal'): ?> checked <?php endif; ?>>
                            <label for="reason3" class="font-weight-normal">
                                For Medico-legal
                            </label>
                        </div>
                    </div>

                    <div class="col-sm-4 mb-2">
                        <div class="icheck-success d-inline">
                            <input type="radio" name="reason" id="reason4" value="Isolation" <?php if(old('reason') == 'Isolation'): ?> checked <?php endif; ?>>
                            <label for="reason4" class="font-weight-normal">
                                Isolation
                            </label>
                        </div>
                    </div>

                    <div class="col-sm-4 mb-2">
                        <div class="icheck-success d-inline">
                            <input type="radio" name="reason" id="reason5" value="Patient's Request" <?php if(old('reason') == "Patient's Request"): ?> checked <?php endif; ?>>
                            <label for="reason5" class="font-weight-normal">
                                Patient's Request
                            </label>
                        </div>
                    </div>

                    <div class="col-sm-4 mb-2">
                        <div class="icheck-success d-inline">
                            <input type="radio" name="reason" id="reason6" value="OPD Consult" <?php if(old('reason') == 'OPD Consult'): ?> checked <?php endif; ?>>
                            <label for="reason6" class="font-weight-normal">
                                OPD Consult
                            </label>
                        </div>
                    </div>

                    
                    <?php $__errorArgs = ['reason'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                        <span>
                            <?php echo e($message); ?>

                        </span>
                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                </div>
            </div>

            <div class="form-group row">
                <label class="col-sm-2 col-form-label">O2 SAT</label>
                <div class="col-sm-10">
                    <input type="text" class="form-control" name="o2_sat" value="<?php echo e(old('o2_sat')); ?>" placeholder="-">
                </div>
            </div>
            

            <div class="form-group row">
                <label class="col-sm-2 col-form-label">REFERRAL TYPE *</label>
                <div class="col-sm-10">
                    <div class="form-group clearfix">
                        <div class="icheck-success d-inline mr-3">
                            <input type="radio" name="referral_type" id="referral_type1" value='Pedia'>
                            <label for="referral_type1" class="font-weight-normal">
                                Pedia
                            </label>
                        </div>
                        <div class="icheck-success d-inline mr-3">
                            <input type="radio" name="referral_type" id="referral_type2" value='Medicine'>
                            <label for="referral_type2" class="font-weight-normal">
                                Medical
                            </label>
                        </div>
                        <div class="icheck-success d-inline mr-3">
                            <input type="radio" name="referral_type" id="referral_type3" value='OB Gyne'>
                            <label for="referral_type3" class="font-weight-normal">
                                OB Gyne
                            </label>
                        </div>
                        <div class="icheck-success d-inline mr-3">
                            <input type="radio" name="referral_type" id="referral_type4" value='Surgery'>
                            <label for="referral_type4" class="font-weight-normal">
                                Surgery
                            </label>
                        </div>
                        <div class="icheck-success d-inline mr-3">
                            <input type="radio" name="referral_type" id="referral_type5" value='COVID 19'>
                            <label for="referral_type5" class="font-weight-normal">
                                COVID 19
                            </label>
                        </div>
                    </div>
                </div>
            </div>

            <hr>

            <div class="form-group row">
                <label class="col-sm-2 col-form-label">RAT RESULT</label>
                <div class="col-sm-10">
                    <div class="form-group clearfix">
                        <div class="icheck-success d-inline mr-3">
                            <input type="radio" name="rat" id="rat1" value='+'>
                            <label for="rat1" class="font-weight-normal">
                                POSITIVE
                            </label>
                        </div>
                        <div class="icheck-success d-inline mr-3">
                            <input type="radio" name="rat" id="rat2" value='-'>
                            <label for="rat2" class="font-weight-normal">
                                NEGATIVE
                            </label>
                        </div>
                        <div class="icheck-success d-inline mr-3">
                            <input type="radio" name="rat" id="ratna" value='na'>
                            <label for="ratna" class="font-weight-normal">
                                NA
                            </label>
                        </div>
                      </div>
                </div>
            </div>

            <div class="form-group row">
                <label class="col-sm-2 col-form-label">RAT ATTACHMENT</label>
                <div class="col-sm-10">
                    <input type="file" accept="image/*" name="rat_attach" id="rat_attach">
                    <button class="btn btn-sm btn-default d-none col-md-2" id="rat_view_btn" data-toggle="modal" data-target="#ratView">
                        <i class="fa fa-file-image"></i>
                         VIEW ATTACHED FILE
                    </button>

                    <!-- Modal -->
                    <div class="modal fade" id="ratView" tabindex="-1" role="dialog" aria-labelledby="ratViewTitle" aria-hidden="true">
                        <div class="modal-dialog modal-dialog-centered modal-lg" role="document">
                        <div class="modal-content">
                            <div class="modal-header">
                                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                    <span aria-hidden="true">&times;</span>
                                </button>
                            </div>
                            <div class="modal-body">
                                <img src="" class="img-fluid" id="rat_preview">
                            </div>
                            <div class="modal-footer justify-content-center">
                                <button type="button" class="btn btn-sm btn-danger col-md-2" id="rat_remove" data-dismiss="modal">REMOVE</button>
                            </div>
                        </div>
                        </div>
                    </div>
                    <!-- Modal -->
                </div>
            </div>

            <hr>

            <div class="form-group row">
                <label class="col-sm-2 col-form-label">RT-PCR RESULT</label>
                <div class="col-sm-10">
                    <div class="form-group clearfix">
                        <div class="icheck-success d-inline mr-3">
                            <input type="radio" name="rtpcr" id="rtpcr1" value='+'>
                            <label for="rtpcr1" class="font-weight-normal">
                                POSITIVE
                            </label>
                        </div>
                        <div class="icheck-success d-inline mr-3">
                            <input type="radio" name="rtpcr" id="rtpcr2" value='-'>
                            <label for="rtpcr2" class="font-weight-normal">
                                NEGATIVE
                            </label>
                        </div>
                        <div class="icheck-success d-inline mr-3">
                            <input type="radio" name="rtpcr" id="na" value='na'>
                            <label for="na" class="font-weight-normal">
                                NA
                            </label>
                        </div>
                      </div>
                </div>
            </div>

            <div class="form-group row">
                <label class="col-sm-2 col-form-label">RT-PCR ATTACHMENT</label>
                <div class="col-sm-10">
                    <input type="file" accept="image/*" name="rtpcr_attach" id="rtpcr_attach">
                    <button class="btn btn-sm btn-default d-none col-md-2" id="rtpcr_view_btn" data-toggle="modal" data-target="#rtpcrView">
                        <i class="fa fa-file-image"></i>
                         VIEW ATTACHED FILE
                    </button>

                    <!-- Modal -->
                    <div class="modal fade" id="rtpcrView" tabindex="-1" role="dialog" aria-labelledby="rtpcrViewTitle" aria-hidden="true">
                        <div class="modal-dialog modal-dialog-centered modal-lg" role="document">
                        <div class="modal-content">
                            <div class="modal-header">
                                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                    <span aria-hidden="true">&times;</span>
                                </button>
                            </div>
                            <div class="modal-body">
                                <img src="" class="img-fluid" id="rtpcr_preview">
                            </div>
                            <div class="modal-footer justify-content-center">
                                <button type="button" class="btn btn-sm btn-danger col-md-2" id="rtpcr_remove" data-dismiss="modal">REMOVE</button>
                            </div>
                        </div>
                        </div>
                    </div>
                    <!-- Modal -->
                </div>
            </div>

            <hr>

            <div class="form-group row">
                <label class="col-sm-2 col-form-label">ADDITIONAL INSTRUCTION</label>
                <div class="col-sm-10">
                    <textarea class="form-control" rows="3" name="add_instruction" placeholder="-"><?php echo e(old('add_instruction')); ?></textarea>
                </div>
            </div>

            <div class="form-group row">
                <label class="col-sm-2 col-form-label">VACCINATION</label>
                <div class="col-sm-10">
                    <div class="form-group clearfix">
                        <div class="icheck-success d-inline mr-3">
                            <input type="checkbox" name="vaccine_1st_dose" id="vaccine_1st_dose">
                            <label for="vaccine_1st_dose" class="font-weight-normal">
                                1st Dose
                            </label>
                        </div>
                        <div class="icheck-success d-inline mr-3">
                            <input type="checkbox" name="vaccine_2nd_dose" id="vaccine_2nd_dose">
                            <label for="vaccine_2nd_dose" class="font-weight-normal">
                                2nd Dose
                            </label>
                        </div>
                      </div>
                </div>
            </div>

            <div class="form-group row">
                <label class="col-sm-2 col-form-label">PHIC ID NO.</label>
                <div class="col-sm-10">
                    <input type="text" class="form-control" name="phic_id_no" value="<?php echo e(old('phic_id_no')); ?>" placeholder="-">
                </div>
            </div>

            <div class="form-group row">
                <label for="inputPassword3" class="col-sm-2 col-form-label">REFERRED BY *</label>
                <div class="col-sm-10">
                    <input type="text" class="form-control" name="ref_by" value="<?php echo e(old('ref_by')); ?>" placeholder="-" required>
                    <?php $__errorArgs = ['ref_by'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                        <span>
                            <?php echo e($message); ?>

                        </span>
                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                </div>
            </div>

            <div class="form-group row">
                <label for="inputPassword3" class="col-sm-2 col-form-label">CONTACT NO.  *</label>
                <div class="col-sm-10">
                    <input type="text" class="form-control" name="contact_no" value="<?php echo e(old('contact_no')); ?>" placeholder="-" required>
                    <?php $__errorArgs = ['contact_no'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                        <span>
                            <?php echo e($message); ?>

                        </span>
                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                </div>
            </div>

            <?php if(isset($_GET['internal'])): ?>
                <div class="form-group row">
                    <label for="inputPassword3" class="col-sm-2 col-form-label">REMARKS </label>
                    <div class="col-sm-10">
                        <textarea class="form-control" rows="6" name="remarks" placeholder="-"><?php echo e(old('remarks')); ?></textarea>
                        <?php $__errorArgs = ['remarks'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <span>
                                <?php echo e($message); ?>

                            </span>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>
                </div>
            <?php endif; ?>

        </div>
        <div class="card-footer justify-content-center text-center">
            <button type="submit" class="btn btn-info">SUBMIT</button>
            <a href="/referrals" class="btn btn-default">CANCEL</a>
        </div>

        <span id="bdate"></span>
    </form>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('script'); ?>
    <script>
        $(function () {


            //Initialize Select2 Elements
            $('.select2').select2()


            $('#rtpcr_attach').on('change', function() {
                $input = $(this);
                if($input.val().length > 0) {
                    fileReader = new FileReader();
                    fileReader.onload = function (data) {
                    $('#rtpcr_preview').attr('src', data.target.result);
                    }
                    fileReader.readAsDataURL($input.prop('files')[0]);
                }
                $(this).addClass('d-none')
                $('#rtpcr_view_btn').removeClass('d-none')
            });
                                    
            $('#rtpcr_remove').on('click', function() {
                $('#rtpcr_attach').val('');	
                $('#rtpcr_attach').removeClass('d-none');	
                $('#rtpcr_view_btn').addClass('d-none')
            });

            $('#rat_attach').on('change', function() {
                $input = $(this);
                if($input.val().length > 0) {
                    fileReader = new FileReader();
                    fileReader.onload = function (data) {
                    $('#rat_preview').attr('src', data.target.result);
                    }
                    fileReader.readAsDataURL($input.prop('files')[0]);
                }
                $(this).addClass('d-none')
                $('#rat_view_btn').removeClass('d-none')
            });
                                    
            $('#rat_remove').on('click', function() {
                $('#rat_attach').val('');	
                $('#rat_attach').removeClass('d-none');	
                $('#rat_view_btn').addClass('d-none')
            });


        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/misnegros/public_html/staging-onehospital/resources/views/referrals/create.blade.php ENDPATH**/ ?>