<?php $__env->startSection('bread-crumb'); ?>
    <div class="row mb-2">
        <div class="col-sm-6">
        <h1>Create Room</h1>
        </div>
        <div class="col-sm-6">
        <ol class="breadcrumb float-sm-right">
            <li class="breadcrumb-item"><a href="/dashboard">Dashboard</a></li>
            <li class="breadcrumb-item"><a href="/hospital/<?php echo e($hospital->id); ?>/station/<?php echo e($station->id); ?>/room"><?php echo e($station->station); ?></a></li>
            <li class="breadcrumb-item active">Create Station</li>
        </ol>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<div class="card card-success card-outline card-tabs">
    <div class="card-body">
        <a href="/hospital/<?php echo e($hospital->id); ?>" class="btn btn-sm btn-success rounded-0" title="Return to <?php echo e($hospital->hospital); ?> dashboard">
            <i class="fa fa-chevron-left"></i> Return
        </a>
        <form class="form-horizontal" action="/hospital/room" method="POST">
            <?php echo csrf_field(); ?>
            <?php if(isset($room)): ?>
                <?php echo method_field('PUT'); ?>
                <input type="hidden" name="id" value="<?php echo e($room->id); ?>">
            <?php endif; ?>
            <div class="card-body">
                <div class="form-group row">
                    <label class="col-sm-2 col-form-label">Hospital *</label>
                    <div class="col-sm-10">
                        <input type="text" class="form-control" value="<?php echo e($hospital->hospital); ?>" readonly>
                        <input type="hidden" class="form-control" id="hospital_id" name="hospital_id" value="<?php echo e($hospital->id); ?>">
                    </div>
                </div>
                <div class="form-group row">
                    <label class="col-sm-2 col-form-label">Station *</label>
                    <div class="col-sm-10">
                        <input type="hidden" class="form-control" id="station_id" name="station_id" value="<?php echo e($station->id); ?>">
                        <input type="text" class="form-control" value="<?php echo e($station->station); ?>" readonly>
                    </div>
                </div>
                <div class="form-group row">
                    <label class="col-sm-2 col-form-label">Room *</label>
                    <div class="col-sm-10">
                        <?php if(isset($room)): ?>
                            <input type="text" class="form-control" id="room" name="room" value="<?php echo e($room->room); ?>">
                        <?php else: ?>
                            <input type="text" class="form-control" id="room" name="room" placeholder="-">
                            <?php $__errorArgs = ['room'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <span>
                                    <?php echo e($message); ?>

                                </span>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        <?php endif; ?>
                    </div>
                </div>
                <div class="form-group row">
                    <label class="col-sm-2 col-form-label">Description</label>
                    <div class="col-sm-10">
                        <?php if(isset($room)): ?>
                            <input type="text" class="form-control" id="description" name="description" value="<?php echo e($room->description); ?>">
                        <?php else: ?>
                            <input type="text" class="form-control" id="description" name="description" placeholder="-">
                            <?php $__errorArgs = ['description'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <span>
                                    <?php echo e($message); ?>

                                </span>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
            <div class="card-footer justify-content-center row">
                <button type="submit" class="btn btn-info">
                    <i class="fa fa-save mr-1"></i>
                     SAVE
                </button>
            </div>
        </form>

        <?php if(session()->has('room.store') || session()->has('room.update') || session()->has('room.destroy')): ?>
            <div class="alert alert-success alert-dismissible col-12 mt-3" id="alert">
                <button type="button" class="close" data-dismiss="alert" aria-hidden="true">&times;</button>
                <i class="icon fas fa-check"></i>
                <?php if(session()->get('room.store')): ?>
                    New room successfully added!
                <?php elseif(session()->get('room.update')): ?>
                    Update Successful!
                <?php elseif(session()->get('room.destroy')): ?>
                    Delete Successful!
                <?php endif; ?>
            </div>
        <?php endif; ?>
    </div>
    <hr>
    <div class="card-body table-responsive p-4">
        <table class="table table-hover text-nowrap">
            <thead>
                <tr>
                    <th>Station</th>
                    <th>Room</th>
                    <th>Description</th>
                    <th>Created at</th>
                    <th></th>
                </tr>
            </thead>
            <tbody>
                <?php $__empty_1 = true; $__currentLoopData = $rooms; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                    <tr>
                        <td><?php echo e($station->station); ?></td>
                        <td><?php echo e($item->room); ?></td>
                        <td><?php echo e($item->description); ?></td>
                        <td><?php echo e($item->created_at); ?></td>
                        <td>
                            <div class="float-right d-flex">
                                <a href="/hospital/<?php echo e($item->hospital_id); ?>/station/<?php echo e($station->id); ?>/room/create?id=<?php echo e($item->id); ?>" class="btn btn-sm btn-info">
                                    <i class="fa fa-edit"></i>
                                </a>
                                &nbsp;
                                <form action="/hospital/room/<?php echo e($item->id); ?>" method="post">
                                    <?php echo csrf_field(); ?>
                                    <?php echo method_field('DELETE'); ?>
                                    <button type="submit" class="btn btn-sm btn-danger">
                                        <i class="fa fa-trash"></i>
                                    </button>
                                </form>
                            </div>
                        </td>
                    </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                    <tr>
                        <td colspan="4" class="text-center text-muted">No beds found.</td>
                    </tr>
                <?php endif; ?>
            </tbody>
        </table>
    </div>

</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/misnegros/public_html/staging-onehospital/resources/views/hospitals/room/create.blade.php ENDPATH**/ ?>