<?php $__env->startSection('bread-crumb'); ?>
    <div class="row mb-2">
        <div class="col-sm-6">
        <h1>Users</h1>
        </div>
        <div class="col-sm-6">
        <ol class="breadcrumb float-sm-right">
            <li class="breadcrumb-item"><a href="/dashboard">Dashboard</a></li>
            <li class="breadcrumb-item active">Users</li>
        </ol>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>


<div class="card card-success card-outline card-tabs">
    <div class="card-body">
        <h3 class="text-center">PASSWORD RESET</h3>
        <p class="text-muted font-italic text-center">SELECT A USER</p>
        <hr>

        <?php if(session()->has('reset')): ?>
            <?php if(session()->get('reset')): ?>
                <div class="alert alert-success alert-dismissible col-12" id="alert">
                    <button type="button" class="close" data-dismiss="alert" aria-hidden="true">&times;</button>
                    <h5><i class="icon fas fa-check"></i> Success!</h5>
                    A new password has been generated on your selected users! They will be notified by email of their new password.
                </div>
            <?php endif; ?>
        <?php endif; ?>

        <form action="/users/pass-reset" method="post">
            <?php echo method_field('PUT'); ?>
            <?php echo csrf_field(); ?>
            <table id="users" class="table table-hover text-nowrap">
                <thead>
                    <tr>
                        <th>User</th>
                        <th>Email</th>
                        <th>Status</th>
                        <th>Role</th>
                        <th>Last Reset Date</th>
                        <th></th>
                    </tr>
                </thead>
                <tbody>

                    <?php $__currentLoopData = $all_users; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <?php $role='-' ?>
                        <?php if($item->assigned_user != null): ?>
                            <?php if($item->assigned_user->role == 2): ?>
                                <?php $role = 'HOD Head' ?>
                            <?php elseif($item->assigned_user->role == 1): ?>
                                <?php $role = 'Hospital' ?>
                            <?php elseif($item->assigned_user->role == 3): ?>
                                <?php $role = 'Super Admin' ?>
                            <?php endif; ?>
                        <?php endif; ?>
                        <tr>
                            <td class="text-capitalize"> <?php echo e($item->fname); ?> <?php echo e($item->lname); ?> <?php if(Auth::user()->id == $item->id): ?> <small>(You)</small> <?php endif; ?></td>
                            <td> <?php echo e($item->email); ?> </td>
                            <td> <?php echo e($item->active == 1 ? 'active' : 'inactive'); ?> </td>
                            <td> <?php echo e($role); ?> </td>
                            <td> <?php echo e($item->last_reset_date != null ? $item->last_reset_date : '-'); ?> </td>
                            <td class="text-center">
                                <div class="icheck-danger d-inline">
                                    <input type="checkbox" id="user-<?php echo e($item->id); ?>" value="<?php echo e($item->id); ?>" name="user_id[]">
                                    <label for="user-<?php echo e($item->id); ?>">
                                    </label>
                                </div>
                            </td>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                </tbody>
                <tfoot>
                    <tr>
                        <th colspan="6" class="text-center">
                            <button class="btn btn-danger" type="submit" id="reset_pass_btn">
                                RESET PASSWORD
                            </button>
                        </th>
                    </tr>
                </tfoot>
            </table>
        </form>
    </div>
    <!-- /.card-body -->
</div>
  <!-- /.card -->
<?php $__env->stopSection(); ?>

<?php $__env->startSection('script'); ?>
    <script>
        $(function () {

            $("form").submit(function(){
                $('#reset_pass_btn').prop('disabled', true)
                $('#reset_pass_btn').text('RESETTING PASSWORD...')
            });
        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/misnegros/public_html/staging-onehospital/resources/views/users/pass-reset.blade.php ENDPATH**/ ?>