<?php $__env->startSection('bread-crumb'); ?>
    <div class="row mb-2">
        <div class="col-sm-6">
        <h1>Users</h1>
        </div>
        <div class="col-sm-6">
        <ol class="breadcrumb float-sm-right">
            <li class="breadcrumb-item"><a href="/dashboard">Dashboard</a></li>
            <li class="breadcrumb-item active">Users</li>
        </ol>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<div class="card">
    <div class="card-header ">
        <h3 class="card-title text-uppercase">Assign a User </h3>
        <small>
            <span class="float-right font-italic text-muted"><b>Note:</b> Assigned user will automatically activated and can already login to the system.</span>
        </small>
    </div>
    <div class="card-body">
        <form class="form-horizontal" action="/user/assign" method="POST">
            <?php echo csrf_field(); ?>
            <div class="card-body">
                <div class="form-group row">
                    <label for="user_id" class="col-sm-2 col-form-label">User *</label>
                    <div class="col-sm-10">
                        <select class="form-control select2" style="width: 100%;" name="user_id" required>
                            <option selected="selected" value="">Please select a user</option>
                            <?php $__empty_1 = true; $__currentLoopData = $unassigned_users; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                <?php if($item->id != Auth::user()->id): ?>
                                    <option value="<?php echo e($item->id); ?>"><?php echo e(ucfirst($item->fname)); ?> <?php echo e(ucfirst($item->lname)); ?></option>
                                <?php endif; ?>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                <option>Sorry, no user found.</option>
                            <?php endif; ?>
                        </select>
                        <?php $__errorArgs = ['user_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <span>
                                User already assigned.
                            </span>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>
                </div>

                <div class="form-group row">
                    <label for="hospital_id" class="col-sm-2 col-form-label">Hospital</label>
                    <div class="col-sm-10">
                        <select class="form-control select2" style="width: 100%;" name="hospital_id">
                            <option selected="selected" value="">Please select a hospital</option>
                            <?php $__empty_1 = true; $__currentLoopData = $hospitals; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                <option value="<?php echo e($item->id); ?>"><?php echo e(ucwords($item->hospital)); ?></option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                <option>Sorry, no hospital found.</option>
                            <?php endif; ?>
                        </select>
                    </div>
                </div>

                <div class="form-group row">
                    <label for="hospital_id" class="col-sm-2 col-form-label">City/Municipality Office</label>
                    <div class="col-sm-10">
                        <select class="form-control select2" style="width: 100%;" name="drrmo_id">
                            <option selected="selected" value="">Please select a DRRMO</option>
                            <?php $__empty_1 = true; $__currentLoopData = $drrmos; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                <option value="<?php echo e($item->id); ?>"><?php echo e(ucwords($item->drrmo)); ?></option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                <option>Sorry, no DRRMO found.</option>
                            <?php endif; ?>
                        </select>
                    </div>
                </div>

                <div class="form-group row">
                    <label for="role" class="col-sm-2 col-form-label">Role *</label>
                    <div class="col-sm-10">
                        <select class="form-control select2" style="width: 100%;" name="role" required>
                            <option selected="selected" value="">Please select a role</option>
                            <option value="3">Super Admin</option>
                            <option value="2">HOD Head</option>
                            <option value="1">Hospital</option>
                            <option value="4">City/Municipality Office</option>
                        </select>
                    </div>
                </div>

                <?php if(session()->has('assigned_user.store')): ?>
                    <?php if(session()->get('assigned_user.store')): ?>
                        <div class="row">
                            <div class="alert alert-success alert-dismissible col-12" id="alert">
                                <button type="button" class="close" data-dismiss="alert" aria-hidden="true">&times;</button>
                                <h5><i class="icon fas fa-check"></i> Success!</h5>
                                User successfully assigned!
                            </div>
                        </div>
                    <?php endif; ?>
                <?php endif; ?>
            </div>
            <div class="card-footer justify-content-center row">
                <button type="submit" class="btn btn-info">
                    <i class="fa fa-save mr-1"></i>
                     SAVE
                </button>
            </div>
        </form>
    </div>

</div>


<div class="card">
    <div class="card-header">
      <h3 class="card-title">Data as of [<span class="text-muted font-italic"><?php echo e(date('Y-m-d')); ?></span>]</h3>
    </div>
    <!-- /.card-header -->
    <div class="card-body">
      <table id="example1" class="table table-hover text-nowrap">
        <thead>
            <tr>
                <th>User</th>
                <th>Email</th>
                <th>Status</th>
                <th>Role</th>
                <th>Date Registered</th>
                <th></th>
            </tr>
        </thead>
        <tbody>


            <?php $__currentLoopData = $users; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <?php $role='-' ?>
                <?php if($item->assigned_user != null): ?>
                    <?php if($item->assigned_user->role == 2): ?>
                        <?php $role = 'HOD Head' ?>
                    <?php elseif($item->assigned_user->role == 1): ?>
                        <?php $role = 'Hospital' ?>
                    <?php elseif($item->assigned_user->role == 3): ?>
                        <?php $role = 'Super Admin' ?>
                    <?php elseif($item->assigned_user->role == 4): ?>
                        <?php $role = 'DRRMO' ?>
                    <?php endif; ?>
                <?php endif; ?>
                <tr>
                    <td class="text-capitalize"> <?php echo e($item->fname); ?> <?php echo e($item->lname); ?> <?php if(Auth::user()->id == $item->id): ?> <small>(You)</small> <?php endif; ?></td>
                    <td> <?php echo e($item->email); ?> </td>
                    <td> <?php echo e($item->active == 1 ? 'active' : 'inactive'); ?> </td>
                    <td> <?php echo e($role); ?> </td>
                    <td> <?php echo e($item->created_at); ?> </td>
                    <td>
                        <a href="/user/<?php echo e($item->id); ?>">
                            <i class="fa fa-folder"></i>
                        </a>
                    </td>
                </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

        </tbody>
        <tfoot>
            <tr>
                <th>User</th>
                <th>Email</th>
                <th>Status</th>
                <th>Role & Designation</th>
                <th>Date Registered</th>
                <th></th>
            </tr>
        </tfoot>
      </table>
    </div>
    <!-- /.card-body -->
</div>
  <!-- /.card -->
<?php $__env->stopSection(); ?>

<?php $__env->startSection('script'); ?>
    <script>
        $(function () {
            $("#example1").DataTable({
                "responsive": true, "lengthChange": false, "autoWidth": false,
                "buttons": ["colvis"]
            }).buttons().container().appendTo('#example1_wrapper .col-md-6:eq(0)');
            //Initialize Select2 Elements
            $('.select2').select2()
        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/misnegros/public_html/staging-onehospital/resources/views/users/index.blade.php ENDPATH**/ ?>