<?php $__env->startSection('content'); ?>
<style>
    .bdr-bot {
        border:none;
        border-radius: 0;
        border-bottom: 1px solid black;
    }
</style>
    <div class="card card-outline card-tabs">
        <div class="card-body">
            <div class="row p-2">
                <div class="col-3 p-1">
                    <h6>REFERRED TO:</h6>

                    <div class="d-flex">
                        <label>Facility:</label>

                        <?php if(!$referral->is_internal): ?>
                            <?php if($receivingH): ?>
                                <input type="text" class="form-control bdr-bot" readonly value="<?php echo e($receivingH->hospital); ?>">
                            <?php else: ?>
                                <input type="text" class="form-control bdr-bot" readonly value="">
                            <?php endif; ?>
                        <?php else: ?>
                            <input type="text" class="form-control bdr-bot" readonly value="">
                        <?php endif; ?>

                    </div>

                    <div class="d-flex">
                        <label>Date:</label>&emsp;&nbsp;
                        <input type="date" class="form-control bdr-bot" name="ref_to_date">
                    </div>

                    <div class="d-flex mb-5">
                        <label>Time:</label>&emsp;
                        <input type="time" class="form-control bdr-bot" name="ref_to_time">
                    </div>

                    <h6>REFERRED FROM:</h6>
                    <div class="d-flex">
                        <label >Facility:</label>

                        <?php if($referral->ref_from_hospital == null): ?>
                            <input type="text" class="form-control bdr-bot" readonly value="<?php echo e($referringH->drrmo); ?>">
                        <?php elseif($referral->ref_from_drrmo == null): ?>
                            <input type="text" class="form-control bdr-bot" readonly value="<?php echo e($referringH->hospital); ?>">
                        <?php endif; ?>

                    </div>

                    <div class="d-flex">
                        <label class="">Date:</label> &emsp;
                        <?php $date=date_create($referral->created_at) ?>
                        <input type="text" class="form-control bdr-bot" value=" <?php echo e(date_format($date,"Y/m/d")); ?> " readonly>
                    </div>

                    <div class="d-flex mb-5">
                        <label>Time:</label>&emsp;
                        <?php $date=date_create($referral->created_at) ?>
                        <input type="text" class="form-control bdr-bot" value=" <?php echo e(date_format($date,"g:i A")); ?> " readonly>
                    </div>

                    <h6>REASON FOR REFERRAL:</h6>
                    <div class="form-group clearfix">
                        <div class="icheck-default d-inline">
                            <input type="radio" readonly <?php if($referral->reason == 'Further evaluation and management'): ?> checked <?php endif; ?>>
                            <label for="reason1">
                                Further evaluation and management
                            </label>
                        </div>
                    </div>
                    <div class="form-group clearfix">
                        <div class="icheck-default d-inline">
                            <input type="radio" readonly <?php if($referral->reason == 'For Work-up'): ?> checked <?php endif; ?>>
                            <label for="reason2">
                                For work-up
                            </label>
                        </div>
                    </div>
                    <div class="form-group clearfix">
                        <div class="icheck-default d-inline">
                            <input type="radio" readonly <?php if($referral->reason == 'For Medico-legal'): ?> checked <?php endif; ?>>
                            <label for="reason3">
                                For medico-legal
                            </label>
                        </div>
                    </div>
                    <div class="form-group clearfix">
                        <div class="icheck-default d-inline">
                            <input type="radio" readonly <?php if($referral->reason == 'Isolation'): ?> checked <?php endif; ?>>
                            <label for="reason4">
                                Isolation
                            </label>
                        </div>
                    </div>
                    <div class="form-group clearfix">
                        <div class="icheck-default d-inline">
                            <input type="radio" readonly <?php if($referral->reason == "Patient's Request"): ?> checked <?php endif; ?>>
                            <label for="reason5">
                                Patient's request
                            </label>
                        </div>
                    </div>
                    <div class="form-group clearfix mb-5">
                        <div class="icheck-default d-inline">
                            <input type="radio" name="reason" readonly <?php if($referral->reason == 'OPD Consult'): ?> checked <?php endif; ?>>
                            <label for="reason6">
                                OPD Consult
                            </label>
                        </div>
                    </div>

                    <h6>PHILHEALTH INFORMATION:</h6>
                    <div class="form-group clearfix mb-3">
                        <div class="icheck-default d-inline">
                            <input type="radio" readonly <?php if($referral->phic_id_no != null): ?> checked <?php endif; ?>>
                            <label for="phealth1">
                                PHIC ID NO
                            </label>
                            <input type="text" class="form-control bdr-bot" value="<?php echo e($referral->phic_id_no); ?>" readonly>
                        </div>
                    </div>
                    <div class="form-group clearfix mb-5">
                        <div class="icheck-default d-inline">
                            <input type="radio" readonly <?php if($referral->phic_id_no == null): ?> checked <?php endif; ?>>
                            <label for="phealth2">
                                Non-PHIC
                            </label>
                        </div>
                    </div>

                    <h6>REFERRED BY:</h6>
                    <input type="text" class="form-control bdr-bot" value="<?php echo e($referral->ref_by); ?>" readonly>
                    <label class="font-italic">Printed Name & Signature</label>

                    <input type="text" class="form-control bdr-bot" name="ref_by_designation">
                    <label class="font-italic">Designation</label>

                    <input type="text" class="form-control bdr-bot" value="<?php echo e($referral->contact_no); ?>" readonly>
                    <label class="font-italic">Contact No.</label>
                </div>

                <div class="col-9 p-1">
                    <div class="row">
                        <div class="col-3 text-right">
                            <img src="<?php echo e(asset('dist/svg-files/pgno_logo_hd.png')); ?>" alt="pgno-log" class="brand-image img-circle w-50" >
                        </div>
                        <div class="col-6 text-center">
                            <p class="p-0 m-0">Republic of the Philippines</p>
                            <p class="p-0 m-0">Province of Negros Occidental</p>
                            <h4 class="p-0 m-0"><?php echo e($referringH->hospital); ?></h4>
                            <h3 class="p-0 m-0">HEALTH REFERRAL FORM</h3>
                        </div>
                        <div class="col-3"></div>
                    </div>

                    <div class="px-5 pt-3">
                        <div class="d-flex mb-2">
                            <label for="">REFERRAL FORM #:</label>
                            <input type="text" class="form-control bdr-bot  text-nowrap" value="<?php echo e($referral->referral_no); ?>" readonly>
                        </div>

                        <div class="d-flex mb-2">
                            <label for="">PATIENT NAME:</label>
                            <input type="text" class="form-control bdr-bot" value="<?php echo e($referral->patient); ?>" readonly>
                        </div>

                        <div class="d-flex mb-2">
                            <label for="">AGE:</label>
                            <input type="text" class="form-control bdr-bot"  value="<?php echo e($referral->age); ?>" readonly>

                            <label for="">SEX:</label>
                            <input type="text" class="form-control bdr-bot"  value="<?php echo e($referral->sex); ?>" readonly>

                            <label for="">BIRTHDATE:</label>
                            <?php $date=date_create($referral->birthdate) ?>
                            <input type="text" class="form-control bdr-bot" value=" <?php echo e(date_format($date,"F d, Y")); ?> " readonly>

                            <label for="">CIVIL STATUS:</label>
                            <input type="text" class="form-control bdr-bot text-nowrap"  value="<?php echo e($referral->civil_status); ?>" readonly">
                        </div>

                        <div class="d-flex mb-2">
                            <label for="">ADDRESS:</label>
                            <input type="text" class="form-control bdr-bot"  value="<?php echo e($referral->address); ?>" readonly>
                        </div>

                        <div class="d-flex mb-2">
                            <label for="">OCCUPATION:</label>
                            <input type="text" class="form-control bdr-bot"  value="<?php echo e($referral->occupation); ?>" readonly>

                            <label for="">RELIGION:</label>
                            <input type="text" class="form-control bdr-bot"  value="<?php echo e($referral->religion); ?>" readonly>
                        </div>

                        <div class="d-flex mb-2">
                            <label for="">PARENT/GUARDIAN (in case of a minor):</label>
                            <input type="text" class="form-control bdr-bot"  value="<?php echo e($referral->guardian); ?>" readonly>
                        </div>

                        <div class="d-flex mb-2">
                            <div class="form-group clearfix">
                                <div class="icheck-default d-inline">
                                    <input type="radio" id="state1" readonly <?php if($referral->state == 'pwd'): ?> checked <?php endif; ?>>
                                    <label for="state1">
                                        PWD
                                    </label>
                                </div>
                            </div>
                            &nbsp;&nbsp;&nbsp;&nbsp;
                            <div class="form-group clearfix">
                                <div class="icheck-default d-inline">
                                    <input type="radio" id="state2" readonly <?php if($referral->state == 'sc'): ?> checked <?php endif; ?>>
                                    <label for="state2">
                                        SC
                                    </label>
                                </div>
                            </div>
                            &nbsp;&nbsp;&nbsp;&nbsp;
                            <div class="form-group clearfix">
                                <div class="icheck-default d-inline">
                                    <input type="radio" id="state3" readonly <?php if($referral->state == 'ic'): ?> checked <?php endif; ?>>
                                    <label for="state3">
                                        IC
                                    </label>
                                </div>
                            </div>
                        </div>

                        <div class="d-flex mb-2">
                            <label for="">CHIEF COMPLAINT:</label>
                            <textarea style="border: 1px solid black" class="form-control" readonly cols="30" rows="3"><?php echo e($referral->complaint); ?></textarea>
                        </div>

                        <div class="d-flex mb-2">
                            <label for="">VITAL SIGNS:</label>
                            <div class=" p-3 w-100 d-flex" style="border: 1px solid black">
                                <label for="">BP:</label>
                                <input type="text" class="form-control bdr-bot" readonly value="<?php echo e($referral->vs_bp); ?>">

                                <label for="">HR:</label>
                                <input type="text" class="form-control bdr-bot" readonly value="<?php echo e($referral->vs_hr); ?>">

                                <label for="">RR:</label>
                                <input type="text" class="form-control bdr-bot" readonly value="<?php echo e($referral->vs_rr); ?>">

                                <label for="">Temp:</label>
                                <input type="text" class="form-control bdr-bot" readonly value="<?php echo e($referral->vs_temp); ?>">

                                <label for="">Weight:</label>
                                <input type="text" class="form-control bdr-bot" readonly value="<?php echo e($referral->vs_weight); ?>">
                            </div>
                        </div>

                        <div class="d-flex mb-2">
                            <label for="">OB HISTORY:</label>
                            <div class="p-3 w-100" style="border: 1px solid black">
                                <div class="d-flex">
                                    <label for="">G:</label>
                                    <input type="text" class="form-control bdr-bot" readonly value="<?php echo e($referral->obh_g); ?>">

                                    <label for="">P:</label>
                                    <input type="text" class="form-control bdr-bot" readonly value="<?php echo e($referral->obh_p); ?>">

                                    <label for="">LMP:</label>
                                    <input type="text" class="form-control bdr-bot" readonly value="<?php echo e($referral->obh_lmp); ?>">

                                    <label for="">EDC:</label>
                                    <input type="text" class="form-control bdr-bot" readonly value="<?php echo e($referral->obh_edc); ?>">

                                    <label for="">AOG:</label>
                                    <input type="text" class="form-control bdr-bot" readonly value="<?php echo e($referral->obh_aog); ?>">
                                </div>

                                <div class="d-flex mt-2">
                                    <label for="">FH:</label>
                                    <input type="text" class="form-control bdr-bot" readonly value="<?php echo e($referral->obh_fh); ?>">

                                    <label for="">FHR:</label>
                                    <input type="text" class="form-control bdr-bot" readonly value="<?php echo e($referral->obh_fhr); ?>">

                                    <label for="">Pelvic Exam:</label>
                                    <input type="text" class="form-control bdr-bot" readonly value="<?php echo e($referral->obh_pelvic); ?>">
                                </div>
                            </div>
                        </div>

                        <div class="d-flex mb-2">
                            <div class="p-3 w-100 d-flex">
                                <label for="">O2 SAT:</label>
                                <input type="text" class="form-control bdr-bot" readonly value="<?php echo e($referral->o2_sat); ?>">

                                <label for="">REFERRAL TYPE:</label>
                                <input type="text" class="form-control bdr-bot" readonly value="<?php echo e($referral->referral_type); ?>">

                                <label for="">RAT:</label>
                                <input type="text" class="form-control bdr-bot" readonly 
                                    <?php if($referral->rat === 1): ?>
                                        value="POSITIVE"
                                    <?php elseif($referral->rat === 0): ?>
                                        value="NEGATIVE"
                                    <?php else: ?>
                                        value="NA"
                                    <?php endif; ?>
                                >

                                <label for="">RTPCR:</label>
                                <input type="text" class="form-control bdr-bot" readonly
                                    <?php if($referral->rtpcr === 1): ?>
                                        value="POSITIVE"
                                    <?php elseif($referral->rtpcr === 0): ?>
                                        value="NEGATIVE"
                                    <?php else: ?>
                                        value="NA"
                                    <?php endif; ?>
                                >

                                <label for="">VACCINATION:</label>
                                <input type="text" class="form-control bdr-bot" readonly 
                                <?php
                                    $vacc_info = 'NA';
                                    if($referral->vaccine_1st_dose === 1) $vacc_info = '1st';
                                    if($referral->vaccine_2nd_dose === 1) $vacc_info .= ' & 2nd';
                                ?>
                                value="<?php echo e($vacc_info); ?>">
                            </div>
                        </div>

                        <div class="d-flex mb-2">
                            <label for="">BRIEF HX AND PE:</label>
                            <textarea style="border: 1px solid black" class="form-control" cols="30" rows="5" readonly><?php echo e($referral->hx_n_pe); ?></textarea>
                        </div>

                        <div class="d-flex mb-2">
                            <label for="">IMPRESSION/DIAGNOSIS: &nbsp;&nbsp;&nbsp;</label>
                            <textarea style="border: 1px solid black" class="form-control" cols="30" rows="6" readonly><?php echo e($referral->diagnosis); ?></textarea>
                        </div>

                        <div class="d-flex mb-2">
                            <label for="">ACTION TAKEN / TREATMENT / MEDICATION GIVEN: &nbsp;&nbsp;&nbsp;</label>
                            <textarea style="border: 1px solid black" class="form-control" rows="7" readonly><?php echo e($referral->medication); ?></textarea>
                        </div>



                        <div class="d-flex mb-2">
                            <label for="">REMARKS: &nbsp;&nbsp;&nbsp;</label>
                            <textarea style="border: 1px solid black" class="form-control" rows="4"><?php echo e($referral->remarks); ?></textarea>
                        </div>


                    </div>
                </div>
            </div>
        </div>

        <div class="card-footer text-center" id="referral_footer">
            <button class="btn btn-danger" id="referral_print">
                <i class="fa fa-print"></i> PRINT
            </button>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('script'); ?>
<script>
    $(function(){
        $('#referral_print').click(function(e) {
            e.preventDefault();
            $('#referral_footer').hide()
            $('.main-footer').hide()
            window.print()
            $('#referral_footer').show()
            $('.main-footer').show()
        })
    })
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/misnegros/public_html/staging-onehospital/resources/views/print/print_referral.blade.php ENDPATH**/ ?>