<?php $__env->startSection('bread-crumb'); ?>
    <div class="row mb-2">
        <div class="col-sm-6">
        <h1>Edit Doctor</h1>
        </div>
        <div class="col-sm-6">
        <ol class="breadcrumb float-sm-right">
            <li class="breadcrumb-item"><a href="/dashboard">Dashboard</a></li>
            <li class="breadcrumb-item active">Edit Doctor</li>
        </ol>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<div class="card">
    <div class="card-header">
        <h3 class="card-title">Creator: <span class="text-muted font-italic text-capitalize"><?php echo e(Auth::user()->fname); ?> <?php echo e(Auth::user()->lname); ?></span></h3>
    </div>
    <div class="card-body">
        <form class="form-horizontal" action="/doctor" method="POST">
            <?php echo csrf_field(); ?>
            <?php echo method_field('PUT'); ?>
            <div class="card-body">
                <div class="form-group row">
                    <label class="col-sm-2 col-form-label">Doctor *</label>
                    <div class="col-sm-10">
                        <input type="text" class="form-control" name="doctor" value="<?php echo e($doctor->doctor); ?>" autofocus required>
                    </div>
                </div>

                <input type="hidden" name="id" value="<?php echo e($doctor->id); ?>">

                <div class="form-group row">
                    <label class="col-sm-2 col-form-label">Designation/Station Assigned *</label>
                    <div class="col-sm-10">
                        <select name="designation" class="form-control select2" style="width: 100%;" required>
                            <option value="">-</option>
                            <?php $__currentLoopData = $stations; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($item->station); ?>" <?php if($item->station == $doctor->designation): ?> selected <?php endif; ?>><?php echo e($item->station); ?></option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                          </select>
                    </div>
                </div>

                <div class="form-group row">
                    <label class="col-sm-2 col-form-label">Specialty *</label>
                    <div class="col-sm-10">
                        <input type="text" class="form-control" name="specialty" value="<?php echo e($doctor->specialty); ?>" required>
                    </div>
                </div>

            </div>
            <div class="card-footer justify-content-center row">
                <button type="submit" class="btn btn-info">
                    <i class="fa fa-save mr-1"></i>
                     UPDATE
                </button>
            </div>
        </form>
    </div>

</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('script'); ?>
    <script>
        $(function(){
            //Initialize Select2 Elements
            $('.select2').select2()
        })
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/misnegros/public_html/staging-onehospital/resources/views/hospitals/doctor/edit.blade.php ENDPATH**/ ?>