<?php

use Illuminate\Support\Facades\Route;
use Illuminate\Support\Facades\Auth;
/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

Route::get('/', 'GuestController@login')->name('guest.login');

Auth::routes();

Route::get('/home', 'HomeController@index')->name('home');

//dashboard
Route::get('/dashboard', 'DashboardController@index')->name('dashboard.index');

//transfer patient
Route::get('/transfer/{referral}', 'TransferPatientController@select')->name('select');
Route::put('/transfer/{referral}', 'TransferPatientController@transfer')->name('transfer');

//referrals
Route::get('/referrals', 'ReferralController@index')->name('referral.index');
Route::get('/referrals/incoming', 'ReferralController@incoming')->name('referral.incoming');
Route::get('/referrals/on-process', 'ReferralController@on_process')->name('referral.on-process');
Route::get('/referrals/done', 'ReferralController@done')->name('referral.done');
Route::get('/referral/create', 'ReferralController@create')->name('referral.create');
Route::get('/referral/{referral}', 'ReferralController@show')->name('referral.show');
Route::post('/referral', 'ReferralController@store')->name('referral.store');
Route::put('/referral/{referral}', 'ReferralController@update')->name('referral.update');
Route::post('/referral/finish-referral', 'ReferralController@finish')->name('referral.finish');
Route::put('/referral/arrived/{referral}', 'ReferralController@patient_arrived')->name('referral.patient_arrived');
Route::get('/referrals/search', 'ReferralController@search')->name('referral.search');
Route::put('/referral/released/{referral}', 'ReferralController@patient_released')->name('referral.patient_released');
Route::post('/referral/direct_refer', 'ReferralController@direct_refer')->name('referral.direct_refer');
Route::get('/referral/transfer_patient', 'ReferralController@transfer_patient')->name('referral.transfer_patient');

//users
Route::get('/users', 'UserController@index')->name('user.index');
Route::get('/user/{user}', 'UserController@show')->name('user.show');
Route::get('/users/pass-reset', 'PasswordResetLogController@index')->name('password_reset.index');
Route::put('/users/pass-reset', 'PasswordResetLogController@update')->name('password_reset.update');

//assigned user
Route::post('/user/assign', 'AssignedUserController@store')->name('assigned_user.store');

//hospitals
Route::get('/hospital', 'HospitalController@create')->middleware('superadmin')->name('hospital.create');
Route::get('/hospital/{hospital}', 'HospitalController@show')->name('hospital.show');
Route::post('/hospital', 'HospitalController@store')->name('hospital.store');
Route::get('/hospitals', 'HospitalController@index')->name('hospital.index');
Route::delete('/hospital/{hospital}', 'HospitalController@destroy')->name('hospital.destroy');

//station
Route::get('/hospital/{hospital}/station', 'StationController@create')->name('station.create');
Route::post('/hospital/station', 'StationController@store')->name('station.store');
Route::put('/hospital/station', 'StationController@update')->name('station.update');
// Route::delete('/hospital/station/{station}', 'StationController@destroy')->name('station.destroy');
Route::delete('/station', 'StationController@destroy')->name('station.destroy');

//rooms
Route::get('/hospital/{hospital_id}/station/{station_id}/room', 'RoomController@index')->name('room.index');
Route::get('/hospital/{hospital}/station/{station}/room/create', 'RoomController@create')->name('room.create');
Route::post('/hospital/room', 'RoomController@store')->name('room.store');
Route::put('/hospital/room', 'RoomController@update')->name('room.update');
Route::delete('/hospital/room/{room}', 'RoomController@destroy')->name('room.destroy');

//beds
Route::get('/hospital/{hospital_id}/station/{station_id}/room/{room_id}/bed', 'BedController@index')->name('bed.index');
Route::get('/hospital/{hospital}/station/{station}/room/{room}/bed/create', 'BedController@create')->name('bed.create');
Route::post('/hospital/bed', 'BedController@store')->name('bed.store');
Route::put('/hospital/bed', 'BedController@update')->name('bed.update');
Route::put('/bed/unavailable', 'BedController@unavailable')->name('bed.unavailable');
Route::put('/bed/available', 'BedController@available')->name('bed.available');
Route::delete('/hospital/bed/{bed}', 'BedController@destroy')->name('bed.destroy');

//audit trails
Route::post('/audittrail', 'AuditTrailController@store')->name('audittrail.store');

//patients
// Route::get('/patients', 'PatientController@index')->name('patient.index');
Route::get('/patient/{patient}', 'PatientController@show')->name('patient.show');
Route::put('/patient/transfer', 'PatientController@update')->name('patient.update');
Route::get('/patient/admitted', 'PatientController@admitted')->name('patient.admitted');
Route::get('/patient/released', 'PatientController@released')->name('patient.released');
Route::post('/patient/walkin', 'PatientController@store')->name('patient.store');

//404
Route::get('/error-404', 'ErrorController@error404')->name('error.error404');

//ambulance
Route::get('/ambulance/create', 'AmbulanceController@create')->name('ambulance.create');
Route::post('/ambulance', 'AmbulanceController@store')->name('ambulance.store');
Route::get('/ambulance/edit/{ambulance}', 'AmbulanceController@edit')->name('ambulance.edit');
Route::put('/ambulance', 'AmbulanceController@update')->name('ambulance.update');
Route::put('/ambulance/list', 'AmbulanceController@update_list')->name('ambulance.update_list');
Route::delete('/ambulance', 'AmbulanceController@destroy')->name('ambulance.destroy');
Route::get('/ambulance/dispatch', 'AmbulanceController@dispatch_ambu')->name('ambulance.dispatch_ambu');
Route::put('/ambulance/dispatch', 'AmbulanceController@dispatch_ambu_update')->name('ambulance.dispatch_ambu_update');

//doctors
Route::get('/doctor/create', 'DoctorController@create')->name('doctor.create');
Route::post('/doctor', 'DoctorController@store')->name('doctor.store');
Route::get('/doctor/edit/{doctor}', 'DoctorController@edit')->name('doctor.edit');
Route::put('/doctor', 'DoctorController@update')->name('doctor.update');
Route::put('/doctors/list', 'DoctorController@update_list')->name('doctor.update_list');
Route::delete('/doctor', 'DoctorController@destroy')->name('doctor.destroy');

//department beds
Route::get('/department/create', 'DepartmentBedController@create')->name('department.create');
Route::post('/department', 'DepartmentBedController@store')->name('department.store');
Route::get('/department/edit/{department}', 'DepartmentBedController@edit')->name('department.edit');
Route::put('/department', 'DepartmentBedController@update')->name('department.update');
Route::delete('/department', 'DepartmentBedController@destroy')->name('department.destroy');
Route::put('/department/dept_occupied/{department}', 'DepartmentBedController@dept_occupied')->name('department.dept_occupied');
Route::put('/department/dept_available/{department}', 'DepartmentBedController@dept_available')->name('department.dept_available');

//doctor sched
Route::get('/doctor-sched/create', 'DoctorScheduleController@create')->name('doc_sched.create');
Route::post('/doctor-sched', 'DoctorScheduleController@store')->name('doc_sched.store');
Route::get('/doctor-sched/edit/{doctorSchedule}', 'DoctorScheduleController@edit')->name('doc_sched.edit');
Route::put('/doctor-sched', 'DoctorScheduleController@update')->name('doc_sched.update');
Route::delete('/doctor-sched', 'DoctorScheduleController@destroy')->name('doc_sched.destroy');

//prints
Route::get('/print/referral/{referral}', 'PrintController@print_referral')->name('print.referral');


//drrmo
Route::get('/drrmos', 'DrrmoController@index')->name('drrmo.index');
Route::get('/drrmo', 'DrrmoController@create')->name('drrmo.create');
Route::post('/drrmo', 'DrrmoController@store')->name('drrmo.store');
Route::get('/drrmo/{drrmo}', 'DrrmoController@show')->name('drrmo.show');
Route::delete('/drrmo/{drrmo}', 'DrrmoController@destroy')->name('drrmo.destroy');

Route::get('/notifications', 'NotificationController@all_notifications')->name('all_notifications');
Route::get('/notifications-h', 'NotificationController@hospital_notifications')->name('hospital_notifications');
Route::get('/notifications-d', 'NotificationController@drrmo_notifications')->name('drrmo_notifications');
Route::get('/notifications-hod', 'NotificationController@hod_notifications')->name('hod_notifications');

Route::get('/profile', 'ProfileController@profile')->name('profile');
Route::get('/change-pass', 'ProfileController@change_pass')->name('change_pass');
Route::post('/change-pass', 'ProfileController@save_pass')->name('save_pass');


Route::post('/change-hospital/{referral}', 'ReferralController@changeHospital')->name('changeHospital');
Route::post('/comment/{referral}', 'CommentController@store')->name('comment');

// Route::get('/reports', 'ReportController@index')->name('report');

Route::get('/print-blank-referral', 'PrintController@print_referral_blank')->name('print.referral_blank');

Route::get('/statistics/admin', 'ReportController@admin')->name('statistics');
Route::get('/statistics/hod', 'ReportController@admin')->name('statistics_hod');
Route::get('/statistics/hospital', 'ReportController@hospital')->name('statistics_h');
Route::get('/statistics/lgu', 'ReportController@lgu')->name('statistics_lgu');

Route::get('/patients', 'PatientController@index')->name('patient.index');
Route::post('/patients/search', 'PatientController@search')->name('patient.search');

Route::post('/referral/search', 'Referral2Controller@search')->name('search_referral');
Route::post('/referral/filter', 'Referral2Controller@filter')->name('filter_referral');
