@extends('layouts.app')

@section('bread-crumb')
    <div class="row mb-2">
        <div class="col-sm-6">
            <h1 class="text-capitalize">{{$user->fname}} {{$user->lname}}</h1>
        </div>
        <div class="col-sm-6">
            <ol class="breadcrumb float-sm-right">
                <li class="breadcrumb-item"><a href="/dashboard">Dashboard</a></li>
                <li class="breadcrumb-item"><a href="/users">User</a></li>
                <li class="breadcrumb-item active text-capitalize">{{$user->fname}} {{$user->lname}}</li>
            </ol>
        </div>
    </div>
@endsection

@section('content')

<div class="card card-widget widget-user">
    <div class="widget-user-header bg-success">
        <h3 class="widget-user-username text-capitalize">{{$user->fname}} {{$user->lname}}</h3>
        <h5 class="widget-user-desc">{{$user->email}}</h5>
    </div>
    <div class="widget-user-image">
        <img class="img-circle elevation-2" src=" {{asset('dist/svg-files/user-avatar.svg')}} " alt="User Avatar">
    </div>
    <div class="card-footer">
        <div class="row">
            <div class="col-sm-6 border-right">
                <div class="description-block">
                    <h5 class="description-header font-weight-light text-monospace">Hospital</h5>
                    <span class="description-text">
                        @if ($assigned->hospital_id != null)
                            {{$hospital->hospital}}
                        @else
                            -
                        @endif
                    </span>
                </div>
            </div>
            <div class="col-sm-6 border-right">
                <div class="description-block">
                    <h5 class="description-header font-weight-light text-monospace">Role</h5>
                    <span class="description-text">
                        @if ($assigned->role == 1)
                            Hospital User
                        @elseif($assigned->role == 2)
                            HOD Head
                        @elseif($assigned->role == 3)
                            Super Admin
                        @endif
                    </span>
                </div>
            </div>

        </div>
    </div>
</div>


<div class="card">
    <div class="card-header">
        <h3 class="card-title">AUDIT TRAIL</h3>

        <div class="card-tools">

        </div>
    </div>
    <!-- /.card-header -->
    <div class="card-body table-responsive ">
        <table class="table table-hover text-nowrap" id="example1">
            <thead>
                <tr>
                    <th style="width: 33%">Action</th>
                    <th style="width: 33%">Remarks</th>
                    <th style="width: 33%" class="text-center">Date</th>
                </tr>
            </thead>
            <tbody>
                @forelse ($audit_trails as $item)
                    <tr>
                        <td class="text-capitalize">{{$item->action}}</td>
                        <td>{{$item->remarks}}</td>
                        <td class="text-center">{{$item->created_at}}</td>
                    </tr>
                @empty
                    <tr>
                        <td colspan="3" class="text-center text-muted">Sorry, no audit trail found.</td>
                    </tr>
                @endforelse
            </tbody>
      </table>
    </div>
</div>

@endsection

@section('script')
    <script>
        $(function () {
            $("#example1").DataTable({
                "responsive": true, "lengthChange": false, "autoWidth": false,
                "buttons": ["colvis"]
            }).buttons().container().appendTo('#example1_wrapper .col-md-6:eq(0)');
            //Initialize Select2 Elements
            $('.select2').select2()
        });
    </script>
@endsection
