@extends('layouts.app')

@section('bread-crumb')
    <div class="row mb-2">
        <div class="col-sm-6">
        <h1>Users</h1>
        </div>
        <div class="col-sm-6">
        <ol class="breadcrumb float-sm-right">
            <li class="breadcrumb-item"><a href="/dashboard">Dashboard</a></li>
            <li class="breadcrumb-item active">Users</li>
        </ol>
        </div>
    </div>
@endsection

@section('content')


<div class="card card-success card-outline card-tabs">
    <div class="card-body">
        <h3 class="text-center">PASSWORD RESET</h3>
        <p class="text-muted font-italic text-center">SELECT A USER</p>
        <hr>

        @if (session()->has('reset'))
            @if (session()->get('reset'))
                <div class="alert alert-success alert-dismissible col-12" id="alert">
                    <button type="button" class="close" data-dismiss="alert" aria-hidden="true">&times;</button>
                    <h5><i class="icon fas fa-check"></i> Success!</h5>
                    A new password has been generated on your selected users! They will be notified by email of their new password.
                </div>
            @endif
        @endif

        <form action="/users/pass-reset" method="post">
            @method('PUT')
            @csrf
            <table id="users" class="table table-hover text-nowrap">
                <thead>
                    <tr>
                        <th>User</th>
                        <th>Email</th>
                        <th>Status</th>
                        <th>Role</th>
                        <th>Last Reset Date</th>
                        <th></th>
                    </tr>
                </thead>
                <tbody>

                    @foreach ($all_users as $item)
                        <?php $role='-' ?>
                        @if ($item->assigned_user != null)
                            @if ($item->assigned_user->role == 2)
                                <?php $role = 'HOD Head' ?>
                            @elseif($item->assigned_user->role == 1)
                                <?php $role = 'Hospital' ?>
                            @elseif($item->assigned_user->role == 3)
                                <?php $role = 'Super Admin' ?>
                            @endif
                        @endif
                        <tr>
                            <td class="text-capitalize"> {{$item->fname}} {{$item->lname}} @if(Auth::user()->id == $item->id) <small>(You)</small> @endif</td>
                            <td> {{$item->email}} </td>
                            <td> {{$item->active == 1 ? 'active' : 'inactive'}} </td>
                            <td> {{$role}} </td>
                            <td> {{$item->last_reset_date != null ? $item->last_reset_date : '-'}} </td>
                            <td class="text-center">
                                <div class="icheck-danger d-inline">
                                    <input type="checkbox" id="user-{{$item->id}}" value="{{$item->id}}" name="user_id[]">
                                    <label for="user-{{$item->id}}">
                                    </label>
                                </div>
                            </td>
                        </tr>
                    @endforeach

                </tbody>
                <tfoot>
                    <tr>
                        <th colspan="6" class="text-center">
                            <button class="btn btn-danger" type="submit" id="reset_pass_btn">
                                RESET PASSWORD
                            </button>
                        </th>
                    </tr>
                </tfoot>
            </table>
        </form>
    </div>
    <!-- /.card-body -->
</div>
  <!-- /.card -->
@endsection

@section('script')
    <script>
        $(function () {

            $("form").submit(function(){
                $('#reset_pass_btn').prop('disabled', true)
                $('#reset_pass_btn').text('RESETTING PASSWORD...')
            });
        });
    </script>
@endsection
