@extends('layouts.app')

@section('bread-crumb')
    <div class="row mb-2">
        <div class="col-sm-6">
            <h1>Profile</h1>
        </div>
    </div>
@endsection

@section('content')
<div class="card card-success card-outline card-tabs">
    <div class="card-body p-5">
        <div class="row">
            <div class="col-md-4">
                <div class="card card-default card-outline">
                    <div class="card-body box-profile">
                        <div class="text-center">
                            <img class="profile-user-img img-fluid img-circle"
                                src="{{asset('dist/svg-files/user-avatar.svg')}}"
                                alt="User profile picture">
                        </div>

                        <h3 class="profile-username text-center">{{$user->fname}}  {{$user->lname}}</h3>

                        <p class="text-muted text-center">
                            @if ($user->role == 1)
                                Hospital
                            @elseif ($user->role == 2)
                                HOD
                            @elseif ($user->role == 3)
                                Admin
                            @elseif ($user->role == 4)
                                City/Municipality User
                            @endif
                        </p>

                        <ul class="list-group list-group-unbordered mb-3">
                            <li class="list-group-item">
                                <b>Email</b> <span class="float-right text-muted">{{$user->email}}</span>
                            </li>
                            @if ($user->role == 1)
                                <li class="list-group-item">
                                    <b>Hospital</b> <span class="float-right text-muted">{{$hospital->hospital}}</span>
                                </li>
                            @elseif ($user->role == 2)
                                <li class="list-group-item">
                                    <b>Office</b> <span class="float-right text-muted">HOD Office</span>
                                </li>
                            @elseif ($user->role == 3)
                                <li class="list-group-item">
                                    <b>Office</b> <span class="float-right text-muted">PDMPD Office</span>
                                </li>
                            @elseif ($user->role == 4)
                                <li class="list-group-item">
                                    <b>City/Municipality</b> <span class="float-right text-muted">{{$lgu->drrmo}}</span>
                                </li>
                            @endif
                        </ul>

                        <a href="/change-pass" class="btn btn-default btn-block"><b>Change Password</b></a>
                        </div>
                        <!-- /.card-body -->
                  </div>
            </div>
        </div>
    </div>
</div>
@endsection
