@extends('layouts.app')

@section('bread-crumb')
    <div class="row mb-2">
        <div class="col-sm-6">
            <h1>Change Password</h1>
        </div>
        <div class="col-sm-6">
            <ol class="breadcrumb float-sm-right">
                <li class="breadcrumb-item"><a href="/profile">Profile</a></li>
                <li class="breadcrumb-item active">Change Password</li>
            </ol>
            </div>
    </div>
@endsection

@section('content')
<div class="card card-success card-outline card-tabs">
    <div class="card-body p-5">
        <div class="row justify-content-center">
            <div class="col-md-4">
                <div class="card card-default card-outline">
                    <div class="card-body box-profile">
                        <form action="/change-pass" method="POST">
                            @csrf
                            <div class="card-body">
                                <div class="form-group">
                                    <label>Old Password</label>
                                    <input type="password" class="form-control" placeholder="Old password" name="old_password" required autofocus>

                                </div>

                                <div class="form-group">
                                    <label>New Password</label>
                                    <input type="password" class="form-control" placeholder="New password" name="password" required>
                                    @error('password')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>

                                <div class="form-group">
                                    <label>Confirm New Password</label>
                                    <input id="password" type="password" class="form-control" placeholder="Confirm new password" name="password_confirmation" required>
                                </div>

                                <button type="submit" class="btn btn-block btn-default text-center">Change Password</button>

                                @if (session()->has('success'))
                                    <div class="alert alert-success mt-3">
                                        <ul>
                                            <li>{{session()->get('success')}}</li>
                                        </ul>
                                    </div>
                                @endif

                                @if (session()->has('err_old_pass'))
                                    <div class="alert alert-danger mt-3">
                                        <ul>
                                            <li>{{session()->get('err_old_pass')}}</li>
                                        </ul>
                                    </div>
                                @endif

                                @if ($errors->any())
                                    <div class="alert alert-danger mt-3">
                                        <ul>
                                            @foreach ($errors->all() as $error)
                                                <li>{{ $error }}</li>
                                            @endforeach
                                        </ul>
                                    </div>
                                @endif


                            </div>

                          </form>

                        </div>
                  </div>
            </div>
        </div>
    </div>
</div>
@endsection
