@extends('layouts.app')

@section('bread-crumb')
    <div class="row mb-2">
        <div class="col-sm-6">
        <h1>Reports</h1>
        </div>
        <div class="col-sm-6">
        <ol class="breadcrumb float-sm-right">
            <li class="breadcrumb-item"><a href="/dashboard">Dashboard</a></li>
            <li class="breadcrumb-item active">Reports</li>
        </ol>
        </div>
    </div>
@endsection

@section('content')
    <div class="row">
        <div class="col-12 col-sm-6 col-md-3">
            <div class="info-box">
                <span class="info-box-icon bg-info elevation-1"><i class="fas fa-procedures"></i></span>

                <div class="info-box-content">
                    <span class="info-box-text">Total Encoded Patients</span>
                    <span class="info-box-number">
                        {{$p_total}}
                    </span>
                </div>
            </div>
        </div>

        <div class="col-12 col-sm-6 col-md-3">
            <div class="info-box">
                <span class="info-box-icon bg-info elevation-1"><i class="fas fa-address-card"></i></span>

                <div class="info-box-content">
                    <span class="info-box-text">Total Created Referrals</span>
                    <span class="info-box-number">
                        {{$ref_total}}
                    </span>
                </div>
            </div>
        </div>

        <div class="col-12 col-sm-6 col-md-3">
            <div class="info-box">
                <span class="info-box-icon bg-info elevation-1"><i class="fas fa-clipboard-list"></i></span>

                <div class="info-box-content">
                    <span class="info-box-text">Total Created Referrals by LGU</span>
                    <span class="info-box-number">
                        {{$lgu_total}}
                    </span>
                </div>
            </div>
        </div>

        <div class="col-12 col-sm-6 col-md-3">
            <div class="info-box">
                <span class="info-box-icon bg-info elevation-1"><i class="fas fa-h-square"></i></span>

                <div class="info-box-content">
                    <span class="info-box-text">Total Created Referrals by Hospital</span>
                    <span class="info-box-number">
                        {{$hosps_total}}
                    </span>
                </div>
            </div>
        </div>





        <div class="col-12 col-sm-6 col-md-6">
            <div class="card card-primary card-outline">
                <div class="card-body table-responsive p-0">
                    <table id="hospital_table" class="table table-hover text-nowrap">
                        <thead>
                            <th>HOSPITAL [{{count($hosp)}}]</th>
                            <th>TOTAL REFERRALS</th>
                        </thead>
                        <tbody>
                            @foreach ($hosp as $item => $value)
                                <tr>
                                    <td>{{$item}}</td>
                                    <td>{{$value}}</td>
                                </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>
            </div>
        </div>

        <div class="col-12 col-sm-6 col-md-6">
            <div id="hospital_chart" width="100%" height="100%"></div>
        </div>

        <div class="col-12 col-sm-6 col-md-6">
            <div class="card card-primary card-outline">
                <div class="card-body table-responsive p-0">
                    <table id="lgu_table" class="table table-hover text-nowrap">
                        <thead>
                            <th>LGU [{{count($lgu)}}]</th>
                            <th>TOTAL REFERRALS</th>
                        </thead>
                        <tbody>
                            @foreach ($lgu as $item => $value)
                                <tr>
                                    <td>{{$item}}</td>
                                    <td>{{$value}}</td>
                                </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>
            </div>
        </div>

        <div class="col-12 col-sm-6 col-md-6">
            <div id="lgu_chart" width="100%" height="100%"></div>
        </div>


    </div>
@endsection

@section('script')
    <script>
        $(function () {
            $("#hospital_table").DataTable({
                "responsive": false, "lengthChange": false, "autoWidth": false, "paging": true, "searching": false, "info": false,
                // "buttons": ["csv"]
            }).buttons().container().appendTo('#hospital_table_wrapper .col-md-6:eq(0)');

            $("#lgu_table").DataTable({
                "responsive": false, "lengthChange": false, "autoWidth": false, "paging": true, "searching": false, "info": false,
                // "buttons": ["csv"]
            }).buttons().container().appendTo('#hospital_table_wrapper .col-md-6:eq(0)');

            var labels = []
            @foreach ($hosp as $item => $value)
                labels.push({ label: '{{$item}}', y: {{$value}} })
            @endforeach

            var options = {
                title: {
                    text: "Created Referrals by Hospital"
                },
                data: [{
                        type: "pie",
                        startAngle: 45,
                        showInLegend: "true",
                        legendText: "{label}",
                        indexLabel: "{label} ({y})",
                        yValueFormatString:"#,##0.#"%"",
                        dataPoints: labels
                }]
            };
            $("#hospital_chart").CanvasJSChart(options);

            var labels = []
            @foreach ($lgu as $item => $value)
                labels.push({ label: '{{$item}}', y: {{$value}} })
            @endforeach

            var options = {
                title: {
                    text: "Created Referrals by LGU"
                },
                data: [{
                        type: "pie",
                        startAngle: 45,
                        showInLegend: "true",
                        legendText: "{label}",
                        indexLabel: "{label} ({y})",
                        yValueFormatString:"#,##0.#"%"",
                        dataPoints: labels
                }]
            };
            $("#lgu_chart").CanvasJSChart(options);
        });
    </script>
@endsection
