@extends('layouts.app')

@section('bread-crumb')
    <div class="row mb-2">
        <div class="col-sm-6">
        <h1>Statistics</h1>
        </div>
        <div class="col-sm-6">
        <ol class="breadcrumb float-sm-right">
            <li class="breadcrumb-item"><a href="/dashboard">Dashboard</a></li>
            <li class="breadcrumb-item active">Statistics</li>
        </ol>
        </div>
    </div>
@endsection

@section('content')
    <div class="row">
        <div class="col-md-12">
            <div class="card card-success color-palette-box">
                <div class="card-header">
                    <h3 class="card-title">
                        <i class="fas fa-file-signature"></i>
                        TOTAL CREATED REFERRALS
                    </h3>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-lg-4 col-6">
                            <div class="small-box bg-success">
                                <div class="inner">
                                    <h3>{{$created_today}}</h3>
                                    <p>TODAY</p>
                                </div>
                                <div class="icon">
                                    <i class="fas fa-file-medical-alt"></i>
                                </div>
                            </div>
                        </div>
                        <div class="col-lg-4 col-6">
                            <div class="small-box bg-success">
                                <div class="inner">
                                    <h3>{{$created}}</h3>
                                    <p>TOTAL</p>
                                </div>
                                <div class="icon">
                                    <i class="fas fa-file-medical-alt"></i>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="row">

                        <div class="col-12 col-sm-6 col-md-3">
                            <div class="info-box">
                                <span class="info-box-icon bg-default elevation-1"><i class="fas fa-file-medical-alt"></i></span>
                    
                                <div class="info-box-content">
                                    <span class="info-box-text">ON-PROCESS</span>
                                    <span class="info-box-number">
                                        {{$created_on_process}}
                                    </span>
                                </div>
                            </div>
                        </div>

                        <div class="col-12 col-sm-6 col-md-3">
                            <div class="info-box">
                                <span class="info-box-icon bg-warning elevation-1"><i class="fas fa-file-medical-alt"></i></span>
                    
                                <div class="info-box-content">
                                    <span class="info-box-text">REFERRED</span>
                                    <span class="info-box-number">
                                        {{$created_referred}}
                                    </span>
                                </div>
                            </div>
                        </div>

                        <div class="col-12 col-sm-6 col-md-3">
                            <div class="info-box">
                                <span class="info-box-icon bg-danger elevation-1"><i class="fas fa-file-medical-alt"></i></span>
                    
                                <div class="info-box-content">
                                    <span class="info-box-text">ADMITTED</span>
                                    <span class="info-box-number">
                                        {{$created_admitted}}
                                    </span>
                                </div>
                            </div>
                        </div>

                        <div class="col-12 col-sm-6 col-md-3">
                            <div class="info-box">
                                <span class="info-box-icon bg-success elevation-1"><i class="fas fa-file-medical-alt"></i></span>
                    
                                <div class="info-box-content">
                                    <span class="info-box-text">RELEASED</span>
                                    <span class="info-box-number">
                                        {{$created_released}}
                                    </span>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>


        <div class="col-md-12">
            <div class="card card-primary color-palette-box">
                <div class="card-header">
                    <h3 class="card-title">
                        <i class="fas fa-file-signature"></i>
                        TOTAL RECEIVED REFERRALS
                    </h3>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-lg-4 col-6">
                            <div class="small-box bg-primary">
                                <div class="inner">
                                    <h3>{{$received_today}}</h3>
                                    <p>TODAY</p>
                                </div>
                                <div class="icon">
                                    <i class="fas fa-file-medical-alt"></i>
                                </div>
                            </div>
                        </div>
                        <div class="col-lg-4 col-6">
                            <div class="small-box bg-primary">
                                <div class="inner">
                                    <h3>{{$received}}</h3>
                                    <p>TOTAL</p>
                                </div>
                                <div class="icon">
                                    <i class="fas fa-file-medical-alt"></i>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="row">

                        <div class="col-12 col-sm-6 col-md-3">
                            <div class="info-box">
                                <span class="info-box-icon bg-warning elevation-1"><i class="fas fa-file-medical-alt"></i></span>
                    
                                <div class="info-box-content">
                                    <span class="info-box-text">INCOMING</span>
                                    <span class="info-box-number">
                                        {{$incoming}}
                                    </span>
                                </div>
                            </div>
                        </div>

                        <div class="col-12 col-sm-6 col-md-3">
                            <div class="info-box">
                                <span class="info-box-icon bg-danger elevation-1"><i class="fas fa-file-medical-alt"></i></span>
                    
                                <div class="info-box-content">
                                    <span class="info-box-text">ADMITTED</span>
                                    <span class="info-box-number">
                                        {{$admitted}}
                                    </span>
                                </div>
                            </div>
                        </div>

                        <div class="col-12 col-sm-6 col-md-3">
                            <div class="info-box">
                                <span class="info-box-icon bg-success elevation-1"><i class="fas fa-file-medical-alt"></i></span>
                    
                                <div class="info-box-content">
                                    <span class="info-box-text">RELEASED</span>
                                    <span class="info-box-number">
                                        {{$released}}
                                    </span>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        
    </div>
@endsection

@section('script')
    <script>
        $(function () {

            
            
        });
    </script>
@endsection
