@extends('layouts.app')

@section('bread-crumb')
    <div class="row mb-2">
        <div class="col-sm-6">
        <h1>REF # {{$referral->referral_no}} </h1>
        </div>
        <div class="col-sm-6">
        <ol class="breadcrumb float-sm-right">
            <li class="breadcrumb-item"><a href="/dashboard">Dashboard</a></li>
            <li class="breadcrumb-item"><a href="/referrals">Referrals</a></li>
            <li class="breadcrumb-item active">REF # {{$referral->referral_no}}</li>
        </ol>
        </div>
    </div>
@endsection

@section('content')
<div class="card card-success card-outline card-tabs">

        <div class="card-header">
            <a href="/print/referral/{{$referral->id}}" class="btn btn-danger" title="Print referral form">
                <i class="fa fa-print"></i> PRINT
            </a>
        </div>

    @if ($referral->ref_status == 1 && Auth::user()->role != 1)
        <form class="form-horizontal" method="POST" action="/referral/{{$referral->id}}">
            @method('PUT')
            @csrf
    @endif
        <div class="card-body p-5">
            <h3 class="text-center mb-2">
                REF # {{$referral->referral_no}}
            </h3>

            <h4 class="text-center mb-5">
                @if ($referral->ref_status == 1)
                    <span class="bg-secondary px-2">
                        ON-PROCESS
                    </span>
                @elseif ($referral->ref_status == 2)
                    <span class="bg-warning px-2">
                        INCOMING
                    </span>
                @elseif ($referral->ref_status == 3)
                    <span class="bg-info px-2">
                        ADMITTED
                    </span>
                @elseif ($referral->ref_status == 4)
                    <span class="bg-success px-2">
                        RELEASED
                    </span>
                @endif
            </h4>

            @if ($errors->any())
                <div class="alert alert-danger">
                    <ul>
                        @foreach ($errors->all() as $error)
                            <li>{{ $error }}</li>
                        @endforeach
                    </ul>
                </div>
            @endif

            @if (session()->has('referral.update'))
                @if (session()->get('referral.update'))
                    <div class="alert alert-success alert-dismissible col-12" id="alert">
                        <button type="button" class="close" data-dismiss="alert" aria-hidden="true">&times;</button>
                        <h5><i class="icon fas fa-check"></i> Success!</h5>
                        REF # {{$referral->referral_no}} successfully sent to selected hospital!
                    </div>
                @endif
            @endif
            @if (session()->has('referral.store'))
                @if (session()->get('referral.store'))
                    <div class="alert alert-success alert-dismissible col-12" id="alert">
                        <button type="button" class="close" data-dismiss="alert" aria-hidden="true">&times;</button>
                        <h5><i class="icon fas fa-check"></i> Success!</h5>
                        New referral successfully added!
                    </div>
                @endif
            @endif


            <div class="form-group row">
                <label for="ref_from_hospital" class="col-sm-2 col-form-label">REFERRED FROM </label>
                <div class="col-sm-10">
                    @if ($referral->is_internal)
                        <input type="text" class="form-control text-capitalize" value="ADDED BY HOSPITAL" readonly>
                    @else
                        @if ($referral->ref_from_hospital != null )
                            @foreach ($hospitals as $item)
                                @if ($item->id == $referral->ref_from_hospital)
                                    <input type="text" class="form-control text-capitalize" value=" {{$item->hospital}} " readonly>
                                @endif
                            @endforeach
                        @else
                            @foreach ($drrmos as $item)
                                @if ($item->id == $referral->ref_from_drrmo)
                                    <input type="text" class="form-control text-capitalize" value=" {{$item->drrmo}} " readonly>
                                @endif
                            @endforeach
                        @endif
                    @endif

                </div>
            </div>

            @if ($referral->ref_to_hospital != null)
                <div class="form-group row">
                    <label for="ref_from_hospital" class="col-sm-2 col-form-label">REFERRED TO </label>
                    <div class="col-sm-10">
                        @foreach ($hospitals as $item)
                            @if ($item->id == $referral->ref_to_hospital)
                                <input type="text" class="form-control" value=" {{$item->hospital}} " readonly>
                            @endif
                        @endforeach
                    </div>
                </div>

                @if ($referral->ref_status != 4 && $referral->ref_status != 1)
                    <div class="form-group row">
                        <label class="col-sm-2 col-form-label">ROOM DETAILS</label>
                        <div class="col-sm-10">

                            @isset($dept_bed)
                                <?php
                                    if($dept_bed->type == 'er') {
                                        $dept = 'Emergency Room';
                                    } elseif($dept_bed->type == 'or') {
                                        $dept = 'Operating Room';
                                    } elseif($dept_bed->type == 'dr') {
                                        $dept = 'Delivery Room';
                                    } elseif($dept_bed->type == 'opd') {
                                        $dept = 'Outpatient Department';
                                    }
                                ?>
                                <input type="text" class="form-control" value="{{$dept}} - {{$dept_bed->bed}}" readonly>
                                @if (Auth::user()->role == 2 || Auth::user()->role == 3 || $referral->ref_to_hospital == Auth::user()->hospital_id)
                                    <a class="font-italic border-bottom" href="/hospital/{{$dept_bed->hospital_id}}?dbed={{$dept_bed->id}}&#dbed{{$dept_bed->id}}" target="_blank" rel="noopener noreferrer">View Hospital</a>
                                @endif

                            @else
                                <input type="text" class="form-control" value="{{$station->station}} - {{$room->room}} - {{$bed->bed}}" readonly>

                                @if (Auth::user()->role == 2 || Auth::user()->role == 3 || $referral->ref_to_hospital == Auth::user()->hospital_id)
                                    <a class="font-italic border-bottom" href="/hospital/{{$bed->hospital_id}}?station={{$station->id}}&bed={{$bed->id}}&#bed{{$bed->id}}" target="_blank" rel="noopener noreferrer">View Hospital</a>
                                @endif

                            @endisset
                        </div>
                    </div>
                @endif
            @endif

            <div class="form-group row">
                <label class="col-sm-2 col-form-label">PATIENT NAME</label>
                <div class="col-sm-10">
                    <input type="text" class="form-control text-capitalize" value=" {{$referral->patient}} " readonly>
                </div>
            </div>

            <div class="form-group row">
                <label class="col-sm-2 col-form-label">AGE</label>
                <div class="col-sm-10">
                    <input type="text" class="form-control" value=" {{$referral->age}} " readonly>
                </div>
            </div>

            <div class="form-group row">
                <label class="col-sm-2 col-form-label">SEX</label>
                <div class="col-sm-10">
                    <input type="text" class="form-control text-capitalize" value=" {{$referral->sex}} " readonly>
                </div>
            </div>

            <div class="form-group row">
                <label class="col-sm-2 col-form-label">BIRTHDATE</label>
                <div class="col-sm-10">
                    <?php $date=date_create($referral->birthdate) ?>
                    <input type="text" class="form-control" value=" {{date_format($date,"Y/m/d")}} " readonly>
                </div>
            </div>

            <div class="form-group row">
                <label class="col-sm-2 col-form-label">CIVIL STATUS</label>
                <div class="col-sm-10">
                    <input type="text" class="form-control  text-capitalize" value=" {{$referral->civil_status}} " readonly>
                </div>
            </div>

            <div class="form-group row">
                <label class="col-sm-2 col-form-label">ADDRESS</label>
                <div class="col-sm-10">
                    <input type="text" class="form-control text-capitalize" value=" {{$referral->address}} " readonly>
                </div>
            </div>

            <div class="form-group row">
                <label class="col-sm-2 col-form-label">OCCUPATION</label>
                <div class="col-sm-10">
                    <input type="text" class="form-control text-capitalize" value=" {{$referral->occupation}} " readonly>
                </div>
            </div>

            <div class="form-group row">
                <label class="col-sm-2 col-form-label">RELIGION</label>
                <div class="col-sm-10">
                    <input type="text" class="form-control" value=" {{$referral->religion}} " readonly>
                </div>
            </div>

            <div class="form-group row">
                <label class="col-sm-2 col-form-label">GUARDIAN</label>
                <div class="col-sm-10">
                    <input type="text" class="form-control text-capitalize" value=" {{$referral->guardian}} " readonly>
                </div>
            </div>

            <div class="form-group row">
                <label class="col-sm-2 col-form-label"></label>
                <div class="col-sm-10">
                    <div class="form-group clearfix">
                        <div class="icheck-success d-inline mr-3">
                            <input type="radio" readonly @if($referral->state == 'pwd') checked @endif>
                            <label for="state1">
                                PWD
                            </label>
                        </div>
                        <div class="icheck-success d-inline mr-3">
                            <input type="radio" readonly @if($referral->state == 'sc') checked @endif>
                            <label for="state2">
                                SC
                            </label>
                        </div>
                        <div class="icheck-success d-inline">
                            <input type="radio" readonly @if($referral->state == 'ic') checked @endif>
                            <label for="state3">
                                IC
                            </label>
                        </div>
                      </div>
                </div>
            </div>

            <div class="form-group row">
                <label class="col-sm-2 col-form-label">CHIEF COMPLAINT</label>
                <div class="col-sm-10">
                    <textarea class="form-control" rows="5" readonly>{{$referral->complaint}}</textarea>
                </div>
            </div>

            <div class="form-group row">
                <label class="col-sm-2 col-form-label">VITAL SIGNS</label>
                <div class="col-sm-10 row">
                    <div class="col-sm-4">
                        <div class="form-group">
                            <label class="font-weight-normal">BP</label>
                            <input type="text" class="form-control form-control-sm" readonly value="{{$referral->vs_bp}}">
                        </div>
                    </div>

                    <div class="col-sm-4">
                        <div class="form-group">
                            <label class="font-weight-normal">HR</label>
                            <input type="text" class="form-control form-control-sm" readonly value="{{$referral->vs_hr}}">
                        </div>
                    </div>

                    <div class="col-sm-4">
                        <div class="form-group">
                            <label class="font-weight-normal">RR</label>
                            <input type="text" class="form-control form-control-sm" readonly value="{{$referral->vs_rr}}">
                        </div>
                    </div>

                    <div class="col-sm-4">
                        <div class="form-group">
                            <label class="font-weight-normal">TEMP</label>
                            <input type="text" class="form-control form-control-sm" readonly value="{{$referral->vs_temp}}">
                        </div>
                    </div>

                    <div class="col-sm-4">
                        <div class="form-group">
                            <label class="font-weight-normal">WEIGHT</label>
                            <input type="text" class="form-control form-control-sm" readonly value="{{$referral->vs_weight}}">
                        </div>
                    </div>
                </div>
            </div>

            <div class="form-group row">
                <label class="col-sm-2 col-form-label">OB HISTORY</label>
                <div class="col-sm-10 row">
                    <div class="col-sm-4">
                        <div class="form-group">
                            <label class="font-weight-normal">G</label>
                            <input type="text" class="form-control form-control-sm" readonly value="{{$referral->obh_g}}">
                        </div>
                    </div>

                    <div class="col-sm-4">
                        <div class="form-group">
                            <label class="font-weight-normal">P</label>
                            <input type="text" class="form-control form-control-sm" readonly value="{{$referral->obh_p}}">
                        </div>
                    </div>

                    <div class="col-sm-4">
                        <div class="form-group">
                            <label class="font-weight-normal">LMP</label>
                            <input type="text" class="form-control form-control-sm" readonly value="{{$referral->obh_lmp}}">
                        </div>
                    </div>

                    <div class="col-sm-4">
                        <div class="form-group">
                            <label class="font-weight-normal">EDC</label>
                            <input type="text" class="form-control form-control-sm" readonly value="{{$referral->obh_edc }}">
                        </div>
                    </div>

                    <div class="col-sm-4">
                        <div class="form-group">
                            <label class="font-weight-normal">AOG</label>
                            <input type="text" class="form-control form-control-sm" readonly value="{{$referral->obh_aog }}">
                        </div>
                    </div>

                    <div class="col-sm-4">
                        <div class="form-group">
                            <label class="font-weight-normal">FH</label>
                            <input type="text" class="form-control form-control-sm" readonly value="{{$referral->obh_fh }}">
                        </div>
                    </div>

                    <div class="col-sm-4">
                        <div class="form-group">
                            <label class="font-weight-normal">FHR</label>
                            <input type="text" class="form-control form-control-sm" readonly value="{{$referral->obh_fhr }}">
                        </div>
                    </div>

                    <div class="col-sm-4">
                        <div class="form-group">
                            <label class="font-weight-normal">PELVIC</label>
                            <input type="text" class="form-control form-control-sm" readonly value="{{$referral->obh_pelvic }}">
                        </div>
                    </div>
                </div>
            </div>

            <div class="form-group row">
                <label class="col-sm-2 col-form-label">BRIEF HX & PE</label>
                <div class="col-sm-10">
                    <textarea class="form-control" rows="5" readonly>{{$referral->hx_n_pe}}</textarea>
                </div>
            </div>

            <div class="form-group row">
                <label class="col-sm-2 col-form-label">IMPRESSION OR DIAGNOSIS</label>
                <div class="col-sm-10">
                    <textarea class="form-control" rows="5" readonly>{{$referral->diagnosis}}</textarea>
                </div>
            </div>

            <div class="form-group row">
                <label class="col-sm-2 col-form-label">MEDICATION/TREATMENT</label>
                <div class="col-sm-10">
                    <textarea class="form-control" rows="5" readonly>{{$referral->medication}}</textarea>
                </div>
            </div>

            <div class="form-group row">
                <label class="col-sm-2 col-form-label">REASON FOR REFERRAL</label>
                <div class="col-sm-10 row">
                    <div class="col-sm-4 mb-2">
                        <div class="icheck-success d-inline">
                            <input type="radio" readonly @if($referral->reason == 'Further evaluation and management') checked @endif>
                            <label for="reason1" class="font-weight-normal">
                                Further evaluation and management
                            </label>
                        </div>
                    </div>

                    <div class="col-sm-4 mb-2">
                        <div class="icheck-success d-inline">
                            <input type="radio" readonly @if($referral->reason == 'For Work-up') checked @endif>
                            <label for="reason2" class="font-weight-normal">
                                For Work-up
                            </label>
                        </div>
                    </div>

                    <div class="col-sm-4 mb-2">
                        <div class="icheck-success d-inline">
                            <input type="radio" readonly @if($referral->reason == 'For Medico-legal') checked @endif>
                            <label for="reason3" class="font-weight-normal">
                                For Medico-legal
                            </label>
                        </div>
                    </div>

                    <div class="col-sm-4 mb-2">
                        <div class="icheck-success d-inline">
                            <input type="radio" readonly @if($referral->reason == 'Isolation') checked @endif>
                            <label for="reason4" class="font-weight-normal">
                                Isolation
                            </label>
                        </div>
                    </div>

                    <div class="col-sm-4 mb-2">
                        <div class="icheck-success d-inline">
                            <input type="radio" readonly @if($referral->reason == "Patient's Request") checked @endif>
                            <label for="reason5" class="font-weight-normal">
                                Patient's Request
                            </label>
                        </div>
                    </div>

                    <div class="col-sm-4 mb-2">
                        <div class="icheck-success d-inline">
                            <input type="radio" name="reason" readonly @if($referral->reason == 'OPD Consult') checked @endif>
                            <label for="reason6" class="font-weight-normal">
                                OPD Consult
                            </label>
                        </div>
                    </div>
                </div>
            </div>

            <div class="form-group row">
                <label class="col-sm-2 col-form-label">O2 SAT</label>
                <div class="col-sm-10">
                    <input type="text" class="form-control" readonly value="{{$referral->o2_sat}}">
                </div>
            </div>

            <div class="form-group row">
                <label class="col-sm-2 col-form-label">REFERRAL TYPE</label>
                <div class="col-sm-10">
                    <div class="form-group clearfix">
                        <div class="icheck-success d-inline mr-3">
                            <input type="radio" readonly @if($referral->referral_type === 'Pedia') checked @endif>
                            <label for="referral_type1" class="font-weight-normal">
                                Pedia
                            </label>
                        </div>
                        <div class="icheck-success d-inline mr-3">
                            <input type="radio" readonly @if($referral->referral_type === 'Medicine') checked @endif>
                            <label for="referral_type2" class="font-weight-normal">
                                Medical
                            </label>
                        </div>
                        <div class="icheck-success d-inline mr-3">
                            <input type="radio" readonly @if($referral->referral_type === 'OB Gyne') checked @endif>
                            <label for="referral_type3" class="font-weight-normal">
                                OB Gyne
                            </label>
                        </div>
                        <div class="icheck-success d-inline mr-3">
                            <input type="radio" readonly @if($referral->referral_type === 'Surgery') checked @endif>
                            <label for="referral_type4" class="font-weight-normal">
                                Surgery
                            </label>
                        </div>
                        <div class="icheck-success d-inline mr-3">
                            <input type="radio" readonly @if($referral->referral_type === 'COVID 19') checked @endif>
                            <label for="referral_type5" class="font-weight-normal">
                                COVID 19
                            </label>
                        </div>
                    </div>
                </div>
            </div>

            <hr>

            <div class="form-group row">
                <label class="col-sm-2 col-form-label">RAT RESULT</label>
                <div class="col-sm-10">
                    <div class="form-group clearfix">
                        <div class="icheck-success d-inline mr-3">
                            <input type="radio" readonly @if($referral->rat === 1) checked @endif>
                            <label for="rat1" class="font-weight-normal">
                                POSITIVE
                            </label>
                        </div>
                        <div class="icheck-success d-inline mr-3">
                            <input type="radio" readonly @if($referral->rat === 0) checked @endif>
                            <label for="rat2" class="font-weight-normal">
                                NEGATIVE
                            </label>
                        </div>
                        <div class="icheck-success d-inline mr-3">
                            <input type="radio" readonly @if($referral->rat === null) checked @endif>
                            <label for="ratna" class="font-weight-normal">
                                NA
                            </label>
                        </div>
                      </div>
                </div>
            </div>

            <div class="form-group row">
                <label class="col-sm-2 col-form-label">RAT ATTACHMENT</label>
                <div class="col-sm-10">
                    <button class="btn btn-sm btn-default col-md-2" id="rat_view_btn" data-toggle="modal" data-target="#ratView">
                        <i class="fa fa-file-image"></i>
                         VIEW ATTACHED FILE
                    </button>

                    <!-- Modal -->
                    <div class="modal fade" id="ratView" tabindex="-1" role="dialog" aria-labelledby="ratViewTitle" aria-hidden="true">
                        <div class="modal-dialog modal-dialog-centered modal-lg" role="document">
                        <div class="modal-content">
                            <div class="modal-header">
                                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                    <span aria-hidden="true">&times;</span>
                                </button>
                            </div>
                            <div class="modal-body">
                                <img src="{{asset('rat-attachments/'.$referral->rat_attach)}}" class="img-fluid" id="rat_preview">
                            </div>
                        </div>
                        </div>
                    </div>
                    <!-- Modal -->
                </div>
            </div>

            <hr>

            <div class="form-group row">
                <label class="col-sm-2 col-form-label">RT-PCR RESULT</label>
                <div class="col-sm-10">
                    <div class="form-group clearfix">
                        <div class="icheck-success d-inline mr-3">
                            <input type="radio" readonly @if($referral->rtpcr === 1) checked @endif>
                            <label for="rtpcr1" class="font-weight-normal">
                                POSITIVE
                            </label>
                        </div>
                        <div class="icheck-success d-inline mr-3">
                            <input type="radio" readonly @if($referral->rtpcr === 0) checked @endif>
                            <label for="rtpcr2" class="font-weight-normal">
                                NEGATIVE
                            </label>
                        </div>

                        <div class="icheck-success d-inline mr-3">
                            <input type="radio" readonly @if($referral->rtpcr === null) checked @endif>
                            <label for="na" class="font-weight-normal">
                                NA
                            </label>
                        </div>
                      </div>
                </div>
            </div>

            <div class="form-group row">
                <label class="col-sm-2 col-form-label">RT-PCR ATTACHMENT</label>
                <div class="col-sm-10">
                    <button class="btn btn-sm btn-default col-md-2" id="rtpcr_view_btn" data-toggle="modal" data-target="#rtpcrView">
                        <i class="fa fa-file-image"></i>
                         VIEW ATTACHED FILE
                    </button>

                    <!-- Modal -->
                    <div class="modal fade" id="rtpcrView" tabindex="-1" role="dialog" aria-labelledby="rtpcrViewTitle" aria-hidden="true">
                        <div class="modal-dialog modal-dialog-centered modal-lg" role="document">
                            <div class="modal-content">
                                <div class="modal-header">
                                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                        <span aria-hidden="true">&times;</span>
                                    </button>
                                </div>
                                <div class="modal-body">
                                    <img src="{{asset('rtpcr-attachments/'.$referral->rtpcr_attach)}}" class="img-fluid" id="rtpcr_preview">
                                </div>
                            </div>
                        </div>
                    </div>
                    <!-- Modal -->
                </div>
            </div>

            <hr>

            <div class="form-group row">
                <label class="col-sm-2 col-form-label">ADDITIONAL INSTRUCTION</label>
                <div class="col-sm-10">
                    <textarea class="form-control" rows="3" readonly>{{ $referral->add_instruction }}</textarea>
                </div>
            </div>

            <div class="form-group row">
                <label class="col-sm-2 col-form-label">VACCINATION</label>
                <div class="col-sm-10">
                    <div class="form-group clearfix">
                        <div class="icheck-success d-inline mr-3">
                            <input type="checkbox"readonly @if($referral->vaccine_1st_dose == true) checked @endif>
                            <label for="vaccine_1st_dose" class="font-weight-normal">
                                1st Dose
                            </label>
                        </div>
                        <div class="icheck-success d-inline mr-3">
                            <input type="checkbox"@if($referral->vaccine_2nd_dose == true) checked @endif>
                            <label for="vaccine_2nd_dose" class="font-weight-normal">
                                2nd Dose
                            </label>
                        </div>
                      </div>
                </div>
            </div>

            <div class="form-group row">
                <label class="col-sm-2 col-form-label">PHIC ID NO.</label>
                <div class="col-sm-10">
                    <input type="text" class="form-control" value="{{$referral->phic_id_no}}" readonly>
                </div>
            </div>

            <div class="form-group row">
                <label class="col-sm-2 col-form-label">REFERRED BY</label>
                <div class="col-sm-10">
                    <input type="text" class="form-control text-capitalize" value="{{$referral->ref_by}}" readonly>
                </div>
            </div>

            <div class="form-group row mb-4">
                <label class="col-sm-2 col-form-label">CONTACT NO.</label>
                <div class="col-sm-10">
                    <input type="text" class="form-control" value="{{$referral->contact_no}}" readonly>
                </div>
            </div>

            @if ($referral->ref_status == 1 && Auth::user()->role == 2)
                <div class="form-group row">
                    <label for="ref_from_hospital" class="col-sm-2 col-form-label">REFER TO *</label>
                    <div class="col-sm-10">
                        @if (session()->has('transfer'))
                            @if (session()->get('transfer'))
                                <div class="alert alert-info alert-dismissible">
                                    <button type="button" class="close" data-dismiss="alert" aria-hidden="true">&times;</button>
                                    <h5><i class="icon fas fa-info"></i> Transfer to different hospital.</h5>
                                    {{session()->get('transfer')}}
                                </div>
                            @endif
                        @endif

                        <select class="form-control select2" name="ref_to_hospital" style="width: 100%;" required @if(session()->has('transfer')) autofocus @endif>
                            <option selected="selected" value="">Please select a hospital</option>
                            @foreach ($hospitals as $item)
                                @if ($item->id != $referral->ref_from_hospital)
                                    <option value="{{$item->id}}" @if($item->id == old('ref_to_hospital')) selected @endif class="text-capitalize"> {{$item->hospital}} </option>
                                @endif

                            @endforeach
                        </select>

                        @error('ref_from_hospital')
                            <span>
                                {{ $message }}
                            </span>
                        @enderror
                    </div>
                </div>
            @endif

            @if ($referral->remarks != null)
                <div class="form-group row">
                    <label class="col-sm-2 col-form-label">REMARKS</label>
                    <div class="col-sm-10">
                        <textarea class="form-control" rows="5" readonly>{{$referral->remarks}}</textarea>
                    </div>
                </div>
            @endif

            <div class="form-group row">
                <label class="col-sm-2 col-form-label">CREATED AT</label>
                <div class="col-sm-10">
                    <?php $date=date_create($referral->created_at) ?>
                    <input type="text" class="form-control" value=" {{date_format($date,"Y/m/d H:i:s")}} " readonly>
                </div>
            </div>

        </div>

        <div class="card-footer justify-content-center text-center">
            @if ($referral->ref_status == 1 || $referral->ref_status == 2)
            <!-- end referral process -->
                <button type="button" class="btn btn-danger" data-toggle="modal" data-target="#end-process-modal">
                    END PROCESS
                </button>
                <!-- end referral process -->
            @endif

            @if (Auth::user()->role == 2 && $referral->ref_status == 2)
                <button type="button" class="btn btn-dark" data-toggle="modal" data-target="#change-hospital-modal">
                    CHANGE HOSPITAL
                </button>
            @endif

            @if ($referral->ref_status == 1 && Auth::user()->role != 1)

                    <button type="submit" class="btn btn-info">SUBMIT</button>
                    <a href="/referrals" class="btn btn-default">CANCEL</a>
            @else
                @if (Auth::user()->hospital_id == $referral->ref_to_hospital)




                        @if ($referral->ref_status == 2)
                        <!-- when referral status is referred -->
                            <button type="button" class="btn btn-info" data-toggle="modal" data-target="#set-arrived-modal">
                                SET ARRIVED
                            </button>

                            <div class="modal fade" id="set-arrived-modal">
                                <div class="modal-dialog modal-lg">
                                    <div class="modal-content">
                                        <div class="modal-header">
                                            <h4 class="modal-title">
                                                <i class="fas fa-check"></i>
                                                Setting patient status into ARRIVED...
                                            </h4>
                                            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                                <span aria-hidden="true">&times;</span>
                                            </button>
                                        </div>
                                        <div class="modal-body">
                                            <div class="alert alert-info alert-dismissible mb-0">
                                                <h5>
                                                    This action cannot be undone.<br>
                                                    Click "Submit" button to update patient status.
                                                </h5>
                                            </div>
                                        </div>
                                        <form action="/referral/arrived/{{$referral->id}}" method="post">
                                            @method('PUT')
                                            @csrf
                                            <div class="modal-footer justify-content-center">
                                                <button type="submit" class="btn btn-info">Submit</button>
                                                <button type="button" class="btn btn-default" data-dismiss="modal">Cancel</button>
                                            </div>
                                        </form>
                                    </div>
                                </div>
                            </div>
                        <!-- when referral status is referred -->
                        @elseif ($referral->ref_status == 3)
                        <!-- when referral status is arrived -->
                            <button type="button" class="btn btn-info" data-toggle="modal" data-target="#set-released-modal">
                                SET RELEASED
                            </button>
                            <div class="modal fade" id="set-released-modal">
                                <div class="modal-dialog modal-lg">
                                    <div class="modal-content">
                                        <div class="modal-header">
                                            <h4 class="modal-title">
                                                <i class="fas fa-check"></i>
                                                Setting patient status into RELEASED...
                                            </h4>
                                            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                                <span aria-hidden="true">&times;</span>
                                            </button>
                                        </div>
                                        <form action="/referral/released/{{$referral->id}}" method="post">
                                        <div class="modal-body">
                                            <div class="form-group row mb-4">
                                                <label class="col-sm-2 col-form-label">REMARKS *</label>
                                                <div class="col-sm-10">
                                                    <textarea class="form-control" rows="5" name="remarks" required></textarea>
                                                </div>
                                            </div>
                                        </div>


                                            @method('PUT')
                                            @csrf
                                            <div class="modal-footer justify-content-center">
                                                <button type="submit" class="btn btn-info">Submit</button>
                                                <button type="button" class="btn btn-default" data-dismiss="modal">Cancel</button>
                                            </div>
                                        </form>

                                    </div>
                                </div>
                            </div>
                        <!-- when referral status is arrived -->


                            <button type="button" class="btn btn-warning" data-toggle="modal" data-target="#transfer-room-modal">
                                TRANSFER ROOM
                            </button>
                            <div class="modal fade" id="transfer-room-modal">
                                <div class="modal-dialog modal-lg">
                                    <div class="modal-content">
                                        <div class="modal-header">
                                            <h4 class="modal-title">
                                                TRANSFER patient to other room?
                                            </h4>
                                            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                                <span aria-hidden="true">&times;</span>
                                            </button>
                                        </div>
                                        <div class="modal-body">
                                            <div class="alert alert-info alert-dismissible mb-0">
                                                <h5>
                                                    This action cannot be undone.<br>
                                                    Click "Proceed" button to transfer patient.
                                                </h5>
                                            </div>
                                        </div>

                                        <div class="modal-footer justify-content-center">
                                            <a href="/hospital/{{$referral->ref_to_hospital}}?transfer=1&referral_id={{$referral->id}}" class="btn btn-warning">
                                                PROCEED
                                            </a>
                                            <button type="button" class="btn btn-default" data-dismiss="modal">Cancel</button>
                                        </div>

                                    </div>
                                </div>
                            </div>


                        @endif

                @endif

            @endif
        </div>

        @if ($referral->ref_status == 1 && Auth::user()->role != 1)
            </form>
        @endif

        @if ($referral->ref_status == 1 || $referral->ref_status == 2)
            <div class="modal fade" id="end-process-modal">
                <div class="modal-dialog modal-lg">
                    <div class="modal-content">
                        <div class="modal-header">
                            <h4 class="modal-title">
                                <i class="fas fa-exclamation-triangle"></i>
                                End REF # {{$referral->referral_no}} process
                            </h4>
                            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                <span aria-hidden="true">&times;</span>
                            </button>
                        </div>
                        <form action="/referral/released/{{$referral->id}}" method="post">
                        <div class="modal-body">
                            <div class="form-group row mb-4">
                                <label class="col-sm-2 col-form-label">REMARKS *</label>
                                <div class="col-sm-10">
                                    <textarea class="form-control" rows="5" name="remarks" required></textarea>
                                </div>
                            </div>

                        </div>

                            @method('PUT')
                            @csrf
                            <div class="modal-footer justify-content-center">
                                <button type="submit" class="btn btn-info">Submit</button>
                                <button type="button" class="btn btn-default" data-dismiss="modal">Cancel</button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        @endif

        @if (Auth::user()->role == 2 && $referral->ref_status == 2)
            <div class="modal fade" id="change-hospital-modal">
                <div class="modal-dialog modal-lg">
                    <div class="modal-content">
                        <div class="modal-header">
                            <h4 class="modal-title">
                                <i class="fas fa-exclamation-triangle"></i>
                                Change hospital for REF # {{$referral->referral_no}}
                            </h4>
                            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                <span aria-hidden="true">&times;</span>
                            </button>
                        </div>
                        <form action="/change-hospital/{{$referral->id}}" method="post">
                            @csrf
                            <div class="modal-body">
                                <div class="alert alert-warning alert-dismissible">
                                    <h5><i class="icon fas fa-exclamation-triangle"></i> Warning!</h5>
                                    The referral will be removed from the hospital you previously selected.
                                </div>

                            </div>
                            <div class="modal-footer justify-content-center">
                                <button type="submit" class="btn btn-danger">Proceed</button>
                                <button type="button" class="btn btn-default" data-dismiss="modal">Cancel</button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        @endif

        <div class="card-body">

            <span class="float-right text-muted">{{count($referral->comments)}} comments</span>
            </div>
              <!-- /.card-body -->
              <div class="card-footer card-comments">

                @foreach ($referral->comments as $comment)
                <div class="card-comment">
                    <!-- User image -->
                    <img class="img-circle img-sm" src="{{asset('dist/svg-files/user-avatar.svg')}}" alt="User Image">

                    <div class="comment-text" id="cmt{{$comment->id}}">
                      <span class="username">
                        <span class="text-capitalize">
                            {{$comment->commentor}}
                            @if ($comment->commentor_id == Auth::user()->id)
                                <small class="font-italic">- You</small>
                            @endif
                        </span>
                        <span class="text-muted float-right">{{$comment->created_at}}</span>
                      </span><!-- /.username -->
                      {{$comment->comment}}
                    </div>
                    <!-- /.comment-text -->
                  </div>
                @endforeach

              </div>
              <!-- /.card-footer -->
              <div class="card-footer">
                <form action="/comment/{{$referral->id}}" method="post">
                    @csrf
                  <img class="img-fluid img-circle img-sm" src="{{asset('dist/svg-files/user-avatar.svg')}}" alt="Alt Text">
                  <!-- .img-push is used to add margin to elements next to floating images -->
                  <div class="img-push">
                    <input type="text" name="comment" class="form-control form-control-sm" placeholder="Press enter to post comment">
                  </div>
                </form>
        </div>

</div>
@endsection

@if ($referral->ref_to_hospital == null && Auth::user()->role != 1)

    @section('script')
        <script>
            $(function () {
                $('.select2').select2()
            });
        </script>
    @endsection

@endif

