@extends('layouts.app')

@section('bread-crumb')
    <div class="row mb-2">
        <div class="col-sm-6">
        <h1>Referrals</h1>
        </div>
        <div class="col-sm-6">
        <ol class="breadcrumb float-sm-right">
            <li class="breadcrumb-item"><a href="/dashboard">Dashboard</a></li>
            <li class="breadcrumb-item active">Referrals</li>
        </ol>
        </div>
    </div>
@endsection

@section('content')
    <div class="card card-info">
        <div class="card-header">

            <!-- search referral -->
            <button type="button" class="btn btn-default mr-2 mb-2" data-toggle="modal" data-target="#searchReferral">
                <i class="fa fa-search"></i> SEARCH REFERRAL
            </button>
            <div class="modal fade" id="searchReferral" tabindex="-1" role="dialog" aria-labelledby="searchReferralTitle" aria-hidden="true" data-backdrop="static">
                <div class="modal-dialog modal-dialog-centered" role="document">
                    <div class="modal-content form">
                        <div id="searchLoading" class="overlay d-none justify-content-center align-items-center">
                            <i class="fas fa-2x fa-sync fa-spin"></i>
                        </div>
                        <div class="modal-body mb-3">
                            <h4 class="lead text-center text-dark">SEARCH FOR REFERRAL</h4>
                            
                            <form id="searchForm" method="post" class="">
                                @csrf
                                <select name="search_by" id="search_by" class="form-control mb-2">
                                    <option value="ref_no">Search by Referral #</option>
                                    <option value="name">Search by Name</option>
                                </select>

                                <input type="text" id="search" name="search" class="form-control form-control-lg" placeholder="REFERRAL #" auto-focus='true'>
                            
                        </div>
                        <div class="modal-footer justify-content-center">
                            <button type="submit" class="btn btn-sm btn-success"><i class="fa fa-search"></i> SEARCH</button>
                            <button type="button" class="btn btn-sm btn-default" data-dismiss="modal">Close</button>
                            </form>
                        </div>
                    </div>
                    <div class="modal-content result d-none text-dark">
                        <div class="modal-body">
                            <button type="button" class="close mb-2" data-dismiss="modal" aria-label="Close">
                                <span aria-hidden="true">&times;</span>
                            </button>
                            <table class="table" id="resultsTable">
                                <tbody></tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
            <!-- search referral -->

            <!-- filter results -->
            <button type="button" class="btn btn-default mr-2  mb-2" data-toggle="modal" data-target="#filterResults">
                <i class="fa fa-filter"></i> FILTER RESULTS
            </button>
            <div class="modal fade" id="filterResults" tabindex="-1" role="dialog" aria-labelledby="filterResultsTitle" aria-hidden="true" data-backdrop="static">
                <div class="modal-dialog modal-dialog-centered" role="document">
                    <div class="modal-content form">
                        <div id="filterLoading" class="overlay d-none justify-content-center align-items-center">
                            <i class="fas fa-2x fa-sync fa-spin"></i>
                        </div>
                        <div class="modal-body mb-3">
                            <h4 class="lead text-center text-dark">FILTER RESULTS BY</h4>
                            
                            <form id="filterForm" method="post" class="">
                                @csrf
                                
                                @if (Auth::user()->role == '1')
                                    <select name="route" id="route" class="form-control mb-2">
                                        <option value="created">Created</option>
                                        <option value="received">Received</option>
                                    </select>
                                @endif

                                <div class="form-group mb-2">
                                    <label for="" class="text-dark">Referral Status:</label>
                                    <select name="status" id="status" class="form-control" required>
                                        <option value="">-</option>
                                        <option id="on_process" value="on_process">On-Process</option>
                                        <option id="referred" value="referred">Referred</option>
                                        <option id="incoming" class="d-none" value="incoming">Incoming</option>
                                        <option value="admitted">Admitted</option>
                                        <option value="released">Released</option>
                                    </select>
                                </div>

                                <div class="form-group mb-2">
                                    <label for="" class="text-dark">Date From:</label>
                                    <input type="date" class="form-control" name="date_from">
                                </div>

                                <div class="form-group mb-2">
                                    <label for="" class="text-dark">Date To:</label>
                                    <input type="date" class="form-control" name="date_to">
                                </div>
                            
                        </div>
                        <div class="modal-footer justify-content-center">
                            <button type="submit" class="btn btn-sm btn-danger"><i class="fa fa-filter"></i> APPLY FILTER</button>
                            <button type="button" class="btn btn-sm btn-default" data-dismiss="modal">Close</button>
                            </form>
                        </div>
                    </div>
                    <div class="modal-content result d-none text-dark">
                        <div class="modal-body">
                            <button type="button" class="close mb-2" data-dismiss="modal" aria-label="Close">
                                <span aria-hidden="true">&times;</span>
                            </button>
                            <table class="table" id="resultsTable">
                                <tbody></tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
            <!-- filter results -->

            @if (Auth::user()->role == 1|| Auth::user()->role == 4)
                <a href="/referral/create" class="btn btn-success  mb-2">
                    <i class="fa fa-address-card"></i> REFER A PATIENT
                </a>
            @endif
        </div>
        <div class="card-body">

            <div class="row">
                <div class="col-12">
                    <div class="card-body table-responsive">
                        <table id="tbl_referrals" class="table table-hover text-nowrap text-uppercase">
                          <thead>
                              <tr>
                                  <th>Referral #</th>
                                  <th>Patient</th>
                                  <th>Age</th>
                                  <th>Sex</th>
                                  <th>Date & Time</th>
                                  <th>Complaint</th>
                                  <th>Status</th>
                                  <th>Remarks</th>
                                  <th></th>
                              </tr>
                          </thead>
                          <tbody>
                              @forelse ($referrals as $item)
                                  <tr @if($item->is_seen == false) style="background-color: #8cd9b3" @endif>
                                      <td> {{$item->referral_no}} </td>
                                      <td> {{$item->patient}} </td>
                                      <td> {{$item->age}} </td>
                                      <td> {{$item->sex}} </td>
                                      <td> {{$item->created_at}} </td>

                                    <?php
                                        $complaint = strip_tags($item->complaint);
                                        if(strlen($complaint) > 30) {
                                            $complaintCut = substr($complaint, 0, 30);
                                            $endPoint = strrpos($complaintCut, ' ');
                                            $complaint = $endPoint ? substr($complaintCut, 0, $endPoint) : substr($complaintCut, 0);
                                            $complaint .= '...';
                                        }

                                        $remarks = strip_tags($item->remarks);
                                        if(strlen($remarks) > 15) {
                                            $remarksCut = substr($remarks, 0, 15);
                                            $endPoint = strrpos($remarksCut, ' ');
                                            $remarks = $endPoint ? substr($remarksCut, 0, $endPoint) : substr($remarksCut, 0);
                                            $remarks .= '...';
                                        }
                                        $remarks = $remarks ? $remarks : 'N/A';
                                    ?>

                                      <td> {{$complaint}} </td>
                                      <td>
                                          @if ($item->ref_status == 1)
                                              {{'On-Process'}}
                                          @elseif ($item->ref_status == 2)
                                              {{'Referred'}}
                                          @elseif ($item->ref_status == 3)
                                              {{'Received'}}
                                          @elseif ($item->ref_status == 4)
                                              {{'Released'}}
                                          @endif
                                      </td>
                                      <td> {{$remarks}} </td>
                                      <td>
                                            <a href="/referral/{{$item->id}}">
                                                <i class="fa fa-address-card"></i>
                                            </a>

                                            <a href="/print/referral/{{$item->id}}" class="btn btn-link text-danger" title="Print referral form">
                                                <i class="fa fa-print"></i>
                                            </a>
                                      </td>
                                  </tr>
                              @empty

                              @endforelse
                          </tbody>
                          <tfoot>
                              <tr>
                                  <th>Referral #</th>
                                  <th>Patient</th>
                                  <th>Age</th>
                                  <th>Sex</th>
                                  <th>Date & Time</th>
                                  <th>Complaint</th>
                                  <th>Status</th>
                                  <th>Remarks</th>
                                  <th></th>
                              </tr>
                          </tfoot>
                        </table>

                        @isset($is_search)
                            
                        @else
                            <div class="mt-3" id="pagination">
                                {{$referrals->links()}}
                            </div>
                        @endisset
                      </div>
                </div>
            </div>
        </div>
    </div>
@endsection

@section('script')
    <script>
        $(function () {
            //Initialize Select2 Elements
            $('.select2').select2()

            $('#route').change(function(e) {
                e.preventDefault();
                var val = $(this).val()
                if(val == 'created') {
                    $('#incoming').addClass('d-none')
                    $('#on_process').removeClass('d-none')
                    $('#referred').removeClass('d-none')
                } else {
                    $('#incoming').removeClass('d-none')
                    $('#on_process').addClass('d-none')
                    $('#referred').addClass('d-none')
                }
                $('#status').prop('selectedIndex',0);
            });

            $('#search_by').change(function(e) {
                e.preventDefault();
                var val = $(this).val()
                if(val == 'name') {
                    $('#search').attr('placeholder', 'PATIENT NAME');
                } else {
                    $('#search').attr('placeholder', 'REFERRAL #');
                }
            });

            $('#filterResults').on('hidden.bs.modal', function (e) {
                $('#incoming').addClass('d-none')
                $('#on_process').removeClass('d-none')
                $('#referred').removeClass('d-none')
                filterForm.reset()
            })

            $('#searchReferral').on('hidden.bs.modal', function (e) {
                $('.form').removeClass('d-none')
                $('.result').addClass('d-none')
                $('#search').attr('placeholder', 'REFERRAL #');
                searchForm.reset()
            })

            filterForm.onsubmit = async (e) => {
                e.preventDefault();
                try {
                    $('#filterLoading').removeClass('d-none').addClass('d-flex')

                    let response = await fetch('/referral/filter', {
                        method: 'POST',
                        body: new FormData(filterForm)
                    });

                    let result = await response.json();

                    let status = response.status

                    if(status == 200) {

                        if(result.length > 0) {
                            let output = '';
                            // $('#tbl_referrals tbody').empty()
                            result.forEach(patient => {
                                let complaint = patient.complaint
                                if(complaint.length > 30) {
                                    complaint = complaint.substring(0, 31);
                                    complaint+= '..'
                                }

                                let remarks = patient.remarks ?? 'NA'

                                var status = ''
                                switch (patient.ref_status) {
                                    case 1:
                                        status = 'ON-PROCESS'
                                        break;

                                    case 2:
                                        status = 'INCOMING/REFERRED'
                                        break;

                                    case 3:
                                        status = 'ADMITTED'
                                        break;

                                    case 4:
                                        status = 'RELEASED'
                                        break;
                                }

                                let d = new Date(patient.created_at)
                                var date = d.getFullYear() + "-" + ("0"+(d.getMonth()+1)).slice(-2) + "-" + ("0" + d.getDate()).slice(-2) +
                                " " + ("0" + d.getHours()).slice(-2) + ":" + ("0" + d.getMinutes()).slice(-2);

                                let row = '<tr><td>'+patient.referral_no+'</td><td>'+patient.patient+'</td><td>'+patient.age+'</td><td>'+patient.sex+'</td><td>'+date+'</td><td>'+complaint+'</td><td>'+status+'</td><td>'+remarks+'</td><td><a href="/referral/'+patient.id+'"><i class="fa fa-address-card"></i></a><a href="/print/referral/'+patient.id+'" class="btn btn-link text-danger" title="Print referral form"><i class="fa fa-print"></i></a></td></tr>'
                                output+=row
                            });

                            
                            if($.fn.DataTable.isDataTable( '#tbl_referrals' )) $("#tbl_referrals").DataTable().destroy()

                            $('#tbl_referrals tbody').empty().html(output)

                            $("#tbl_referrals").DataTable({
                                "responsive": true, "lengthChange": false, "autoWidth": false,
                                "buttons": ["copy", "csv", "excel", "pdf", "print"],
                                "searching": false,
                                "order": [[5, "desc" ]],
                                "columnDefs": [ { type: 'date', 'targets': [5] } ],
                            }).buttons().container().appendTo('#tbl_referrals_wrapper .col-md-6:eq(0)');
                        } else {
                            if($.fn.DataTable.isDataTable( '#tbl_referrals' )) $("#tbl_referrals").DataTable().destroy()
                            
                            $('#tbl_referrals tbody').empty().html('<tr><td colspan="9" class="font-italic text-center border-0"><h3 class="m-0 p-0">No record found.</h3></td></tr>')
                        }


                    } else {
                        $('#tbl_referrals tbody').empty().html('<tr><td colspan="9" class="font-italic text-center border-0"><h3 class="m-0 p-0">Records are too large. Please contact system admin.</h3></td></tr>')
                    }
                }
                finally{
                    $('#filterLoading').removeClass('d-flex').addClass('d-none')
                    $('#filterResults').modal('toggle');
                    $('#pagination').addClass('d-none')
                    filterForm.reset()
                }
            };

            searchForm.onsubmit = async (e) => {
                e.preventDefault();
                try {
                    $('#searchLoading').removeClass('d-none').addClass('d-flex')

                    let response = await fetch('/referral/search', {
                        method: 'POST',
                        body: new FormData(searchForm)
                    });

                    let result = await response.json();

                    if(result.length > 0) {
                        let output = '';
                        result.forEach(patient => {
                            let row = '<tr><td><a href="/referral/'+patient.id+'" class="text-dark">'+patient.referral_no+' | <span class="text-uppercase text-primary">'+patient.patient+'</span> - '+patient.age+', '+patient.sex+', '+patient.address+'</a></td></tr>'
                            output+=row
                        });
                        $('#resultsTable tbody').empty().html(output)
                    } else {
                        $('#resultsTable tbody').empty().html('<tr><td class="font-italic text-center border-0"><h3 class="m-0 p-0">No record found.</h3></td></tr>')
                    }
                    
                }
                finally{
                    $('#searchLoading').removeClass('d-flex').addClass('d-none')
                    $('.form').addClass('d-none')
                    $('.result').removeClass('d-none')
                }
            };
        });
    </script>
@endsection
