@extends('layouts.app')

@section('bread-crumb')
    <div class="row mb-2">
        <div class="col-sm-6">
        <h1>Notifications</h1>
        </div>
        <div class="col-sm-6">
        <ol class="breadcrumb float-sm-right">
            <li class="breadcrumb-item"><a href="/dashboard">Dashboard</a></li>
            <li class="breadcrumb-item active">Notifications</li>
        </ol>
        </div>
    </div>
@endsection

@section('content')
<div class="card card-widget card-success card-outline card-tabs">

    <div class="card-body">
        <table class="table table-hover" id="notif">


            @forelse ($notifications as $item)
                <tr>
                    <td class="p-1">
                        @if ($item->type == 'comment')
                            <a href="{{$item->link}}?notif={{$item->id}}&#{{$item->div_id}}" target="_blank" rel="noopener noreferrer">
                        @else
                            <a href="{{$item->link}}?notif={{$item->id}}" target="_blank" rel="noopener noreferrer">
                        @endif
                            <div class="p-2" @if($item->is_seen != 1) style="background-color: #e0ebeb" @endif>
                                <p class="text-muted m-0">{{$item->ref_no}}</p>
                                <span class="float-right">{{$item->created_at}}</span>
                                <span>{{$item->notification}}</span>
                            </div>
                        </a>

                    </td>
                </tr>
            @empty
                <h5 class="text-center text-muted font-italic">
                    No notification found.
                </h5>
            @endforelse

            @if ($notifications->total() > 0)
                <tr>
                    <td class="text-center">
                        {{ $notifications->links() }}
                    </td>
                </tr>
            @endif
        </table>
    </div>

</div>
@endsection


    @section('script')
        <script>
            $(function () {
                //
            });
        </script>
    @endsection


