<!doctype html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">

    <!-- CSRF Token -->
    <meta name="csrf-token" content="{{ csrf_token() }}">

    <title>{{ config('app.name', 'One Hospital') }}</title>

    <!-- Fonts -->
    <link rel="dns-prefetch" href="//fonts.gstatic.com">
    <link href="https://fonts.googleapis.com/css?family=Nunito" rel="stylesheet">

    <!-- Google Font: Source Sans Pro -->
    <link rel="stylesheet" href="https://fonts.googleapis.com/css?family=Source+Sans+Pro:300,400,400i,700&display=fallback">

    <!-- Font Awesome -->
    <link rel="stylesheet" href=" {{asset('plugins/fontawesome-free/css/all.min.css')}} ">
    <!-- pace-progress -->
    <link rel="stylesheet" href=" {{asset('plugins/pace-progress/themes/black/pace-theme-flat-top.css')}} ">
     <!-- DataTables -->
    <link rel="stylesheet" href=" {{asset('plugins/datatables-bs4/css/dataTables.bootstrap4.min.css')}} ">
    <link rel="stylesheet" href=" {{asset('plugins/datatables-responsive/css/responsive.bootstrap4.min.css')}} ">
    <link rel="stylesheet" href=" {{asset('plugins/datatables-buttons/css/buttons.bootstrap4.min.css')}} ">
    <!-- iCheck for checkboxes and radio inputs -->
    <link rel="stylesheet" href=" {{asset('plugins/icheck-bootstrap/icheck-bootstrap.min.css')}} ">
    <!-- Select2 -->
    <link rel="stylesheet" href=" {{asset('plugins/select2/css/select2.min.css')}} ">
    <link rel="stylesheet" href=" {{asset('plugins/select2-bootstrap4-theme/select2-bootstrap4.min.css')}} ">
    <!-- adminlte-->
    <link rel="stylesheet" href=" {{asset('dist/css/adminlte.min.css')}} ">

    <!-- Styles -->
    {{-- <link href="{{ asset('css/app.css') }}" rel="stylesheet"> --}}
    <style>
        .glowing-circle {
            background-color: #fff;
            -webkit-animation: glowing 1s ease-in-out infinite alternate;
            -moz-animation: glowing 1s ease-in-out infinite alternate;
            animation: glowing 1s ease-in-out infinite alternate;
        }
        @-webkit-keyframes glowing {
            from {
                box-shadow: 0 0 10px #fff, 0 0 20px #fff, 0 0 30px #02680f, 0 0 40px #0ff, 0 0 50px #07f424, 0 0 60px #07f424, 0 0 70px #07f424;
            }
            to {
                box-shadow: 0 0 20px #fff, 0 0 30px #02b018, 0 0 40px #02b018, 0 0 50px #02b018, 0 0 60px #02b018, 0 0 70px #02b018, 0 0 80px #02b018;
            }
        }

        .image-input
            text-aling: center
            input
                display: none !important
            label
                display: block
                color: #FFF
                background: #000	
                padding: .3rem .6rem
                font-size: 115%
                cursor: pointer
                i
                    font-size: 125%
                    margin-right: .3rem
                &:hover
                    i
                        animation: shake .35s
            img
                max-width: 175px
                display: none
            span
                display: none
                text-align: center
                cursor: pointer

            
    </style>
</head>

<style>
    input:read-only, textarea:read-only {
        background-color: white !important;
    }
</style>

<?php $page = Route::currentRouteName();?>

@guest
    <body class="hold-transition @if($page == 'login') login-page @else register-page @endif">
@else
    <body class="hold-transition sidebar-mini ">
@endguest

    <div id="app">
    @guest

        @if ($page == 'login')
            <div class="login-box">
                <div class="login-logo">
                    <a href="#"><b>ONE HOSPITAL</b></a>

                </div>
                <!-- /.login-logo -->
                <div class="card">
                <div class="card-body login-card-body">
                    <p class="login-box-msg">Sign in to start your session</p>

                    <form action="{{ route('login') }}" method="post">
                        @csrf
                        <div class="input-group mb-3">
                            <input id="email" type="email" placeholder="Email" class="form-control @error('email') is-invalid @enderror" name="email" value="{{ old('email') }}" required autocomplete="email" autofocus>
                            <div class="input-group-append">
                                <div class="input-group-text">
                                    <span class="fas fa-envelope"></span>
                                </div>
                            </div>
                            @error('email')
                                <span class="invalid-feedback" role="alert">
                                    <strong>{{ $message }}</strong>
                                </span>
                            @enderror
                        </div>

                        <div class="input-group mb-3">
                            <input id="password" type="password" placeholder="Password" class="form-control @error('password') is-invalid @enderror" name="password" required autocomplete="current-password">
                            <div class="input-group-append">
                                <div class="input-group-text">
                                    <span class="fas fa-lock"></span>
                                </div>
                            </div>
                            @error('password')
                                <span class="invalid-feedback" role="alert">
                                    <strong>{{ $message }}</strong>
                                </span>
                            @enderror
                        </div>
                        <div class="row">
                            <div class="col-8">
                                <div class="icheck-primary">
                                    <input type="checkbox" name="remember" id="remember" {{ old('remember') ? 'checked' : '' }}>
                                    <label for="remember">
                                    Remember Me
                                    </label>
                                </div>
                            </div>
                            <!-- /.col -->
                            <div class="col-4">
                                <button type="submit" class="btn btn-primary btn-block">Sign In</button>
                            </div>
                            <!-- /.col -->
                        </div>
                    </form>

                    @if (Route::has('password.request'))
                        <p class="mb-1">
                            <a class="text-center" href="{{ route('password.request') }}">
                                {{ __('Forgot Your Password?') }}
                            </a>
                        </p>
                    @endif
                    <p class="mb-0">
                        <a href="/register" class="text-center">Register an account</a>
                    </p>

                    <p class="text-wrap mt-4">
                        @if (session()->has('inactive'))
                            {{session()->get('inactive')}}
                        @endif
                    </p>
                </div>
                <!-- /.login-card-body -->
                </div>

            </div>


        @else
            <div class="register-box">
                <div class="register-logo">
                    <a href="#"><b>ONE HOSPITAL</b></a>
                </div>

                <div class="card">
                    <div class="card-body register-card-body">
                        <p class="login-box-msg">Register an account</p>

                        <form action="{{ route('register') }}" method="post">
                            @csrf
                            <div class="input-group mb-3">
                                <input id="fname" type="text" placeholder="First name" class="form-control @error('fname') is-invalid @enderror" name="fname" value="{{ old('fname') }}" required autocomplete="fname" autofocus>
                                <div class="input-group-append">
                                    <div class="input-group-text">
                                        <span class="fas fa-user"></span>
                                    </div>
                                </div>
                                @error('fname')
                                    <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                @enderror
                            </div>

                            <div class="input-group mb-3">
                                <input id="lname" type="text" placeholder="Last name" class="form-control @error('lname') is-invalid @enderror" name="lname" value="{{ old('lname') }}" required autocomplete="lname" autofocus>
                                <div class="input-group-append">
                                    <div class="input-group-text">
                                        <span class="fas fa-user"></span>
                                    </div>
                                </div>
                                @error('lname')
                                    <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                @enderror
                            </div>

                            <div class="input-group mb-3">
                                <input id="email" type="email" placeholder="Email" class="form-control @error('email') is-invalid @enderror" name="email" value="{{ old('email') }}" required autocomplete="email">
                                <div class="input-group-append">
                                    <div class="input-group-text">
                                        <span class="fas fa-envelope"></span>
                                    </div>
                                </div>
                                @error('email')
                                    <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                @enderror
                            </div>

                            <div class="input-group mb-3">
                                <input id="password" type="password" placeholder="Password" class="form-control @error('password') is-invalid @enderror" name="password" required autocomplete="new-password">
                                <div class="input-group-append">
                                    <div class="input-group-text">
                                        <span class="fas fa-lock"></span>
                                    </div>
                                </div>
                                @error('password')
                                    <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                @enderror
                            </div>

                            <div class="input-group mb-3">
                                <input id="password-confirm" type="password" placeholder="Retype password" class="form-control" name="password_confirmation" required autocomplete="new-password">
                                <div class="input-group-append">
                                    <div class="input-group-text">
                                        <span class="fas fa-lock"></span>
                                    </div>
                                </div>
                            </div>

                            <div class="row justify-content-center mb-4">
                                <div class="col-4">
                                    <button type="submit" class="btn btn-primary btn-block">Register</button>
                                </div>
                            </div>
                        </form>

                        <a href="/login" class="text-center">I already have an account</a>
                    </div>

                </div>
            </div>
        @endif



    @else

        <div class="wrapper">
            <nav class="main-header navbar navbar-expand navbar-white navbar-light">
                <ul class="navbar-nav">
                    <li class="nav-item">
                        <a class="nav-link" data-widget="pushmenu" href="#" role="button"><i class="fas fa-bars"></i></a>
                    </li>
                </ul>


                <ul class="navbar-nav ml-auto">


                    <li class="nav-item">
                        <a class="nav-link" data-widget="fullscreen" href="#" role="button">
                            <i class="fas fa-expand-arrows-alt"></i>
                        </a>
                    </li>
                </ul>
            </nav>

            <aside class="main-sidebar sidebar-dark-primary elevation-4">
            <a href="#" class="brand-link">
                <img src="{{asset('dist/svg-files/pgno_logo.svg')}}" alt="pgno-log" class="brand-image img-circle elevation-3">
                <span class="brand-text font-weight-light">ONE HOSPITAL</span>
            </a>
            <div class="sidebar">
                <div class="user-panel mt-3 pb-3 mb-3 d-flex">
                    <div class="image">
                        <img src="{{asset('dist/svg-files/user-avatar.svg')}}" class="img-circle elevation-2" alt="User Image">
                    </div>
                    <div class="info">
                        <a href="/profile" class="d-block text-capitalize">{{Auth::user()->fname}} {{Auth::user()->lname}}</a>
                    </div>
                </div>

                <nav class="mt-2">
                    <ul class="nav nav-pills nav-sidebar flex-column" data-widget="treeview" role="menu" data-accordion="false">

                        @if (Auth::user()->role != 1 && Auth::user()->role != 4)
                            <li class="nav-item">
                                <a href="/dashboard" class="nav-link @if($page == 'dashboard.index') active @endif">
                                    <i class="nav-icon fas fa-tachometer-alt"></i>
                                    <p>Dashboard</p>
                                </a>
                            </li>
                        @endif

                        <li class="nav-item">
                            <a href="/referrals" class="nav-link @if($page == '') active @endif">
                                <i class="nav-icon fas fa-address-card"></i>
                                <p>Referrals</p>
                            </a>
                        </li>

                        @if (Auth::user()->role == 1)
                            <li class="nav-item">
                                <a href="/patients" class="nav-link @if($page == 'patient.index') active @endif">
                                    <i class="nav-icon fas fa-procedures"></i>
                                    <p>Patients</p>
                                </a>
                            </li>
                        @endif

                        @if (Auth::user()->role != 4)
                            @if (Auth::user()->role != 1)
                                <li class="nav-item">
                                    <a href="/hospitals" class="nav-link @if($page == '') active @endif">
                                        <i class="nav-icon fas fa-h-square"></i>
                                        <p>Hospitals</p>
                                    </a>
                                </li>

                                <li class="nav-item">
                                    <a href="/drrmos" class="nav-link @if($page == '') active @endif">
                                        <i class="nav-icon fas fa-briefcase-medical"></i>
                                        <p>City/Municipality</p>
                                    </a>
                                </li>
                            @else
                                <li class="nav-item">
                                    <a href="/hospital/{{Auth::user()->hospital_id}}" class="nav-link @if($page == '') active @endif">
                                        <i class="nav-icon fas fa-h-square"></i>
                                        <p>Facility</p>
                                    </a>
                                </li>
                            @endif
                        @endif

                        @if (Auth::user()->role == 3)
                            <li class="nav-item">
                                <a href="/statistics/admin" class="nav-link @if($page == 'statistics') active @endif">
                                    <i class="nav-icon fas fa-file-medical-alt"></i>
                                    <p>Statictics</p>
                                </a>
                            </li>
                        @endif

                        @if (Auth::user()->role == 2)
                            <li class="nav-item">
                                <a href="/statistics/hod" class="nav-link @if($page == 'statistics_hod') active @endif">
                                    <i class="nav-icon fas fa-file-medical-alt"></i>
                                    <p>Statictics</p>
                                </a>
                            </li>
                        @endif

                        @if (Auth::user()->role == 4)
                            <li class="nav-item">
                                <a href="/statistics/lgu" class="nav-link @if($page == 'statistics_hod') active @endif">
                                    <i class="nav-icon fas fa-file-medical-alt"></i>
                                    <p>Statictics</p>
                                </a>
                            </li>
                        @endif

                        @if (Auth::user()->role == 1)
                            <li class="nav-item">
                                <a href="/statistics/hospital" class="nav-link @if($page == 'statistics_h') active @endif">
                                    <i class="nav-icon fas fa-file-medical-alt"></i>
                                    <p>Statictics</p>
                                </a>
                            </li>
                        @endif

                        <li class="nav-header">SYSTEM SETTINGS</li>

                        <li class="nav-item">
                            @if (Auth::user()->role == 3)
                                <a href="/notifications" class="nav-link @if($page == 'all_notifications') active @endif">
                            @elseif(Auth::user()->role == 2)
                                <a href="/notifications-hod" class="nav-link @if($page == 'hod_notifications') active @endif">
                            @elseif(Auth::user()->role == 1)
                                <a href="/notifications-h" class="nav-link @if($page == 'hospital_notifications') active @endif">
                            @elseif(Auth::user()->role == 4)
                                <a href="/notifications-d" class="nav-link @if($page == 'drrmo_notifications') active @endif">
                            @endif
                                <i class="nav-icon far fa-bell"></i>
                                <p>
                                Notifications


                                    @isset($notifs)
                                        @if (count($notifs))
                                            <span class="badge badge-warning right" id="notif-ctr"> {{ count($notifs) }} </span>
                                        @endif
                                    @else
                                        <span class="badge badge-warning right" id="notif-ctr"></span>
                                    @endisset


                                </p>
                            </a>
                        </li>

                        @if (Auth::user()->role == 3)

                            <li class="nav-item">
                                <a href="/users" class="nav-link @if($page == 'user.index' || $page == 'user.show') active @endif">
                                    <i class="nav-icon fa fa-users"></i>
                                    <p>
                                    Users
                                    </p>
                                </a>
                            </li>

                            <li class="nav-item">
                                <a href="/users/pass-reset" class="nav-link @if($page == 'password_reset.index') active @endif">
                                    <i class="nav-icon fa fa-user-lock"></i>
                                    <p>
                                    User Password Reset
                                    </p>
                                </a>
                            </li>
                        @endif
                        <li class="nav-item">
                            <a class="nav-link" href="{{ route('logout') }}"
                                onclick="event.preventDefault();
                                          document.getElementById('logout-form').submit();">
                                <i class="nav-icon fa fa-power-off"></i>
                                <p>
                                Logout
                                </p>
                            </a>
                            <form id="logout-form" action="{{ route('logout') }}" method="POST" class="d-none">
                                @csrf
                            </form>
                        </li>

                    </ul>
                </nav>
            </div>
            </aside>

            <div class="content-wrapper">
                <section class="content-header">
                    <div class="container-fluid">

                        @yield('bread-crumb')

                    </div>
                </section>

                <section class="content">

                    @yield('content')

                </section>
            </div>

            <footer class="main-footer">
                <div class="float-right d-none d-sm-block">
                    {{-- Feedback & bug reports email: josegenelidojrc@gmail.com --}}
                </div>
                Copyright &copy; 2021 Negros Occidental - Provincial Administrator's Office.
            </footer>

            <aside class="control-sidebar control-sidebar-dark">
            </aside>
        </div>

    @endguest
    </div>

    <!-- jQuery -->
    <script src=" {{asset('plugins/jquery/jquery.min.js')}} "></script>
    <!-- Bootstrap 4 -->
    <script src=" {{asset('plugins/bootstrap/js/bootstrap.bundle.min.js')}} "></script>
    <!-- pace-progress -->
    <script src=" {{asset('plugins/pace-progress/pace.min.js')}} "></script>

    <script src="{{asset('plugins/dropzone/min/dropzone.min.js')}}"></script>

    @if (
            $page == 'hospital.show' || $page == 'hospital.index' ||
            $page == 'drrmo.show' || $page == 'drrmo.index' ||
            $page == 'patient.index' ||
            $page == 'doctor.create' ||
            $page == 'user.index' || $page == 'user.show' ||
            $page == 'referral.create' || $page == 'referral.show' || $page == 'referral.index' || $page == 'referral.search' ||
            $page == 'referral.on-process' || $page == 'referral.done' || $page == 'referral.incoming' ||
            $page == 'ambulance.dispatch_ambu'

        )
        <script src=" {{asset('plugins/datatables/jquery.dataTables.min.js')}} "></script>
        <script src=" {{asset('plugins/datatables-bs4/js/dataTables.bootstrap4.min.js')}} "></script>
        <script src=" {{asset('plugins/datatables-responsive/js/dataTables.responsive.min.js')}} "></script>
        <script src=" {{asset('plugins/datatables-responsive/js/responsive.bootstrap4.min.js')}} "></script>
        <script src=" {{asset('plugins/datatables-buttons/js/dataTables.buttons.min.js')}} "></script>
        <script src=" {{asset('plugins/datatables-buttons/js/buttons.bootstrap4.min.js')}} "></script>
        <script src=" {{asset('plugins/jszip/jszip.min.js')}} "></script>
        <script src=" {{asset('plugins/pdfmake/pdfmake.min.js')}} "></script>
        <script src=" {{asset('plugins/pdfmake/vfs_fonts.js')}} "></script>
        <script src=" {{asset('plugins/datatables-buttons/js/buttons.html5.min.js')}} "></script>
        <script src=" {{asset('plugins/datatables-buttons/js/buttons.print.min.js')}} "></script>
        <script src=" {{asset('plugins/datatables-buttons/js/buttons.colVis.min.js')}} "></script>
        <script src=" {{asset('plugins/bootstrap-switch/js/bootstrap-switch.min.js')}} "></script>

        <!-- Select2 -->
        <script src=" {{asset('plugins/select2/js/select2.full.min.js')}} "></script>
    @endif

    @if ($page == 'dashboard.index' || $page == 'statistics' || $page == 'statistics_hod')
    {{-- <script type="text/javascript" src="https://canvasjs.com/assets/script/jquery-1.11.1.min.js"></script>
        <script type="text/javascript" src="https://canvasjs.com/assets/script/jquery.canvasjs.min.js"></script> --}}
        <script src=" {{asset('canvasjs-3.4.2/jquery.canvasjs.min.js')}} "></script>
        <script src=" {{asset('canvasjs-3.4.2/canvasjs.min.js')}} "></script>

        <script src=" {{asset('plugins/chart.js/Chart.min.js')}} "></script>
        <script src=" {{asset('plugins/datatables/jquery.dataTables.min.js')}} "></script>
        <script src=" {{asset('plugins/datatables-bs4/js/dataTables.bootstrap4.min.js')}} "></script>
        <script src=" {{asset('plugins/datatables-responsive/js/dataTables.responsive.min.js')}} "></script>
        <script src=" {{asset('plugins/datatables-responsive/js/responsive.bootstrap4.min.js')}} "></script>
        <script src=" {{asset('plugins/datatables-buttons/js/dataTables.buttons.min.js')}} "></script>
        <script src=" {{asset('plugins/datatables-buttons/js/buttons.bootstrap4.min.js')}} "></script>
        <script src=" {{asset('plugins/datatables-buttons/js/buttons.html5.min.js')}} "></script>
        <script src=" {{asset('plugins/datatables-buttons/js/buttons.print.min.js')}} "></script>
        <script src=" {{asset('plugins/datatables-buttons/js/buttons.colVis.min.js')}} "></script>


    @endif


    <!-- AdminLTE App -->
    <script src=" {{asset('dist/js/adminlte.min.js')}} "></script>
    <!-- AdminLTE for demo purposes -->
    <script src=" {{asset('dist/js/demo.js')}} "></script>

    <!-- Scripts -->

    @if ($page == 'referral.create' || $page == 'referral.direct_refer')

        <script>
            $('#birthdate').change(function() {
                dob = new Date($(this).val());
                var today = new Date();
                if(dob<today) {
                    var age = Math.floor((today-dob) / (365.25 * 24 * 60 * 60 * 1000));
                    if(age > 0) {
                        $('#age').val(age+' y.o');
                    } else {
                        var dob_m = dob.getMonth() + 1, tod_m = today.getMonth() + 1
                        age = tod_m - dob_m

                        if(age > 0) {
                            $('#age').val(age+' m.o')
                        } else {
                            var tod_d = today.getDate(), dob_d = dob.getDate()
                            age = tod_d - dob_d
                            $('#age').val(age+' d.o')
                        }
                    }
                }
            })
        </script>

    @endif

    @auth
        <script src="https://js.pusher.com/7.0/pusher.min.js"></script>
        @if (Auth::user()->role == 2)
            <script src="{{ asset('js/hod-head-pusher-config.js') }}" defer></script>
        @elseif(Auth::user()->role == 1)
            <script>
                let hospital_id = "{{Auth::user()->hospital_id}}"
            </script>
            <script src="{{ asset('js/hospital-pusher-config.js') }}" defer></script>
        @elseif(Auth::user()->role == 4)
            <script>
                let drrmo_id = "{{Auth::user()->drrmo_id}}"
            </script>
            <script src="{{ asset('js/drrmo-pusher-config.js') }}" defer></script>
        @endif
    @endauth

    @yield('script')
</body>
</html>
