@extends('layouts.app')

@section('bread-crumb')
    <div class="row mb-2">
        <div class="col-sm-6">
        <h1>Create Doctor</h1>
        </div>
        <div class="col-sm-6">
        <ol class="breadcrumb float-sm-right">
            <li class="breadcrumb-item"><a href="/dashboard">Dashboard</a></li>
            <li class="breadcrumb-item active">Create Doctor</li>
        </ol>
        </div>
    </div>
@endsection

@section('content')
<div class="card card-success card-outline card-tabs">
    <div class="card-body">
        <a href="/hospital/{{$hospital->id}}" class="btn btn-sm btn-success rounded-0" title="Return to {{$hospital->hospital}} dashboard">
            <i class="fa fa-chevron-left"></i> Return
        </a>
        <a href="/doctor-sched/create?hospital_id={{$hospital->id}}" class="btn btn-sm btn-warning rounded-0">
            <i class="fa fa-calendar" aria-hidden="true"></i> Create Schedule
        </a>
        <h4 class="text-center text-uppercase">
            {{$hospital->hospital}}
        </h4>
        <hr>

        <form class="form-horizontal" action="/doctor" method="POST">
        @isset($doctor)
            @method('PUT')
        @endisset

            @csrf
            <div class="card-body">
                <div class="form-group row">
                    <label class="col-sm-2 col-form-label">Doctor *</label>
                    <div class="col-sm-10">
                        @isset($doctor)
                            <input type="text" class="form-control" name="doctor" value="{{$doctor->doctor}}" autofocus required>
                            <input type="hidden" name="id" value="{{$doctor->id}}">
                        @else
                            <input type="text" class="form-control" name="doctor" value="" autofocus required>
                            <input type="hidden" name="hospital_id" value="<?= $_GET['hospital_id'] ?>">
                        @endisset
                    </div>
                </div>
                <div class="form-group row">
                    <label class="col-sm-2 col-form-label">Specialty *</label>
                    <div class="col-sm-10">
                        @isset($doctor)
                            <input type="text" class="form-control" name="specialty" value="{{$doctor->specialty}}" required>
                        @else
                            <input type="text" class="form-control" name="specialty" required>
                        @endisset
                    </div>
                </div>

            </div>
            <div class="card-footer justify-content-center row">
                <button type="submit" class="btn btn-info">
                    <i class="fa fa-save mr-1"></i>

                    @isset($doctor)
                        UPDATE
                    @else
                        SAVE
                    @endisset
                </button>
            </div>
        </form>
        @if (session()->has('doctor.store') || session()->has('doctor.update') || session()->has('doctor.destroy'))
            <div class="alert alert-success alert-dismissible col-12 mt-3" id="alert">
                <button type="button" class="close" data-dismiss="alert" aria-hidden="true">&times;</button>
                <i class="icon fas fa-check"></i>
                @if (session()->get('doctor.store'))
                    New doctor successfully added!
                @elseif(session()->get('doctor.update'))
                    Update Successful!
                @elseif(session()->get('doctor.destroy'))
                    Delete Successful!
                @endif
            </div>
        @endif
    </div>
    <hr>
    <div class="card-body table-responsive p-4">
        <table class="table table-hover text-nowrap">
            <thead>
                <tr>
                    <th>Doctor</th>
                    <th>Specialty</th>
                    <th></th>
                </tr>
            </thead>
            <tbody>
                @forelse ($doctors as $dr_item)
                    <tr>
                        <td>{{$dr_item->doctor}}</td>
                        <td>{{$dr_item->specialty}}</td>
                        <td>
                            <div class="float-right d-flex">
                                <a href="/doctor/edit/{{$dr_item->id}}" class="btn btn-sm btn-info">
                                    <i class="fa fa-edit"></i>
                                </a>
                                &nbsp;
                                <form action="/doctor" method="post">
                                    @csrf
                                    @method('DELETE')
                                    <input type="hidden" name="dr_id" value="{{$dr_item->id}}">
                                    <button type="submit" class="btn btn-sm btn-danger">
                                        <i class="fa fa-trash"></i>
                                    </button>
                                </form>
                            </div>
                        </td>
                    </tr>
                @empty
                    <tr>
                        <td colspan="3" class="text-center text-muted">No doctors found.</td>
                    </tr>
                @endforelse
            </tbody>
        </table>
    </div>

</div>
@endsection

@section('script')
    <script>
        $(function(){
            //Initialize Select2 Elements
            $('.select2').select2()
        })
    </script>
@endsection
