@extends('layouts.app')

@section('bread-crumb')
    <div class="row mb-2">
        <div class="col-sm-6">
            <h1>{{$beds[0]->room}}</h1>
        </div>
        <div class="col-sm-6">
            <ol class="breadcrumb float-sm-right">
                <li class="breadcrumb-item"><a href="/dashboard">Dashboard</a></li>
                <li class="breadcrumb-item"><a href="/hospital/{{$hospital->id}}">{{$hospital->hospital}}</a></li>
                <li class="breadcrumb-item"><a href="/hospital/{{$rooms[0]->id}}">{{$rooms[0]->station}}</a></li>
                <li class="breadcrumb-item active">{{$beds[0]->room}}</li>
            </ol>
        </div>
    </div>
@endsection

@section('content')

<div class="card">
    <div class="card-header">
        <h3 class="card-title text-capitalize">{{$beds[0]->room}} - {{$beds[0]->description}}</h3>

        <!-- super admin only -->
        @if (Auth::user()->role == 3)
            <button class="btn btn-default float-right" data-toggle="modal" data-target="#modal-lg">
                <i class="fa fa-trash"></i>
                Delete this room
            </button>
        @endif
        <!-- super admin only -->

    </div>
    <div class="card-body">
        <div class="row">


            @foreach ($beds[0]->bed as $item)
                <div class="col-12 col-sm-6 col-md-3">
                    @isset($ref_no)
                            <div class="info-box border-none">
                                @if ($item->status == 1)
                                    <span class="info-box-icon bg-success elevation-1"><i class="fas fa-bed"></i></span>
                                @elseif($item->status == 2)
                                    <span class="info-box-icon bg-warning elevation-1"><i class="fas fa-bed"></i></span>
                                @elseif($item->status == 3)
                                    <span class="info-box-icon bg-danger elevation-1"><i class="fas fa-bed"></i></span>
                                @endif

                                <div class="info-box-content d-flex">


                                        @if ($item->status == 1)
                                            <span class="info-box-text text-capitalize">
                                                Available
                                                <button class="btn float-right btn-link text-dark" data-toggle="modal" data-target="#bed-{{$item->id}}">
                                                    <i class="fa fa-edit fa-lg"></i>
                                                </button>
                                            </span>

                                        @elseif($item->status == 2)
                                            <span class="info-box-text text-capitalize">
                                                Incoming
                                            </span>
                                        @elseif($item->status == 3)
                                            <span class="info-box-text text-capitalize">
                                                Occupied
                                            </span>
                                        @endif

                                    <span class="info-box-number">
                                        {{$item->bed}}

                                        @if ($item->status != 1)
                                            <a class="text-decoration-none text-dark float-right font-italic text-muted font-weight-normal" href="/patient/{{$item->patient_id}}" target="_blank" rel="noopener noreferrer">
                                                Patient Details
                                            </a>
                                        @endif
                                    </span>
                                </div>
                            </div>

                            @if ($item->status == 1)
                                <div class="modal fade" id="bed-{{$item->id}}">
                                    <div class="modal-dialog modal-lg">
                                        <div class="modal-content">
                                            <div class="modal-header">
                                                <h4 class="modal-title">
                                                    <i class="fas fa-check"></i>
                                                    Available!
                                                </h4>
                                                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                                    <span aria-hidden="true">&times;</span>
                                                </button>
                                            </div>
                                            <div class="modal-body">
                                                <div class="alert alert-default alert-dismissible mb-0">
                                                    <h5>
                                                        This bed is available.<br>
                                                        Click "Submit" to reserve REF #{{$ref_no}} here.
                                                    </h5>
                                                </div>
                                            </div>

                                            <form action="/referral/finish-referral" method="post">
                                                @csrf
                                                <input type="hidden" name="ref_no" value="{{$ref_no}}">
                                                <input type="hidden" name="bed_id" value="{{$item->id}}">
                                                <div class="modal-footer justify-content-center">
                                                    <button type="submit" class="btn btn-primary">Submit</button>
                                                    <button type="button" class="btn btn-default" data-dismiss="modal">Cancel</button>
                                                </div>
                                            </form>

                                        </div>
                                    </div>
                                </div>
                            @endif
                    @else
                        @isset($patient_id)
                            <div class="info-box border-none">
                                @if ($item->status == 1)
                                    <span class="info-box-icon bg-success elevation-1"><i class="fas fa-bed"></i></span>
                                @elseif($item->status == 2)
                                    <span class="info-box-icon bg-warning elevation-1"><i class="fas fa-bed"></i></span>
                                @elseif($item->status == 3)
                                    <span class="info-box-icon bg-danger elevation-1"><i class="fas fa-bed"></i></span>
                                @endif

                                <div class="info-box-content d-flex">


                                        @if ($item->status == 1)
                                            <span class="info-box-text text-capitalize">
                                                Available
                                                <button class="btn float-right btn-link text-dark" data-toggle="modal" data-target="#bed-{{$item->id}}">
                                                    <i class="fa fa-edit fa-lg"></i>
                                                </button>
                                            </span>

                                        @elseif($item->status == 2)
                                            <span class="info-box-text text-capitalize">
                                                Incoming
                                            </span>
                                        @elseif($item->status == 3)
                                            <span class="info-box-text text-capitalize">
                                                Occupied
                                            </span>
                                        @endif

                                    <span class="info-box-number">
                                        {{$item->bed}}

                                        @if ($item->status != 1)
                                            <a class="text-decoration-none text-dark float-right font-italic text-muted font-weight-normal" href="/patient/{{$item->patient_id}}" target="_blank" rel="noopener noreferrer">
                                                Patient Details
                                            </a>
                                        @endif
                                    </span>
                                </div>
                            </div>

                            @if ($item->status == 1)
                                <div class="modal fade" id="bed-{{$item->id}}">
                                    <div class="modal-dialog modal-lg">
                                        <div class="modal-content">
                                            <div class="modal-header">
                                                <h4 class="modal-title">
                                                    <i class="fas fa-check"></i>
                                                    Available!
                                                </h4>
                                                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                                    <span aria-hidden="true">&times;</span>
                                                </button>
                                            </div>
                                            <div class="modal-body">
                                                <div class="alert alert-default alert-dismissible mb-0">
                                                    <h5>
                                                        This bed is available.<br>
                                                        Click "Submit" to transfer patient here.
                                                    </h5>
                                                </div>
                                            </div>

                                            <form action="/patient/transfer" method="post">
                                                @method('PUT')
                                                @csrf
                                                <input type="hidden" name="patient_id" value="{{$patient_id}}">
                                                <input type="hidden" name="bed_id" value="{{$item->id}}">
                                                <div class="modal-footer justify-content-center">
                                                    <button type="submit" class="btn btn-primary">Submit</button>
                                                    <button type="button" class="btn btn-default" data-dismiss="modal">Cancel</button>
                                                </div>
                                            </form>

                                        </div>
                                    </div>
                                </div>
                            @endif
                        @else
                            <div class="info-box border-none">
                                @if ($item->status == 1)
                                    <span class="info-box-icon bg-success elevation-1"><i class="fas fa-bed"></i></span>
                                @elseif($item->status == 2)
                                    <span class="info-box-icon bg-warning elevation-1"><i class="fas fa-bed"></i></span>
                                @elseif($item->status == 3)
                                    <span class="info-box-icon bg-danger elevation-1"><i class="fas fa-bed"></i></span>
                                @endif

                                <div class="info-box-content">
                                    <span class="info-box-text text-capitalize">
                                        @if ($item->status == 1)
                                            Available
                                        @elseif($item->status == 2)
                                            Incoming
                                        @elseif($item->status == 3)
                                            Occupied
                                            <a class="text-decoration-none text-dark float-right tooltip-test" data-toggle="tooltip" data-placement="top" title="Transfer to other bed." href="/hospital/{{$item->hospital_id}}?transfer=1&id={{$item->patient_id}}" target="_blank" rel="noopener noreferrer">
                                                <i class="fa fa-share fa-lg"></i>
                                            </a>
                                        @endif
                                    </span>
                                    <span class="info-box-number">
                                        {{$item->bed}}

                                        @if ($item->status != 1)
                                            <a class="text-decoration-none text-dark float-right font-italic text-muted font-weight-normal" title="Tooltip" href="/patient/{{$item->patient_id}}" target="_blank" rel="noopener noreferrer">
                                                Patient Details
                                            </a>
                                        @endif
                                    </span>
                                </div>
                            </div>
                        @endisset
                    @endisset
                </div>
            @endforeach

            <!-- super admin only -->
            @if (Auth::user()->role == 3)
                <div class="col-12 col-sm-6 col-md-3">
                    <a href="/hospital/{{$rooms[0]->hospital_id}}/station/{{$rooms[0]->id}}/room/{{$beds[0]->id}}/bed/create" class="text-dark">
                        <div class="info-box border-none">
                            <span class="info-box-icon bg-secondary elevation-1"><i class="fas fa-plus"></i></span>
                            <div class="info-box-content">
                                <span class="info-box-text text-capitalize">New bed</span>
                                <span class="info-box-number">

                                </span>
                            </div>
                        </div>
                    </a>
                </div>

                @if (session()->has('room.store'))
                    @if (session()->get('room.store'))
                        <div class="alert alert-success alert-dismissible col-12 mx-2" id="alert">
                            <button type="button" class="close" data-dismiss="alert" aria-hidden="true">&times;</button>
                            <h5><i class="icon fas fa-check"></i> Success!</h5>
                            New room successfully added
                        </div>
                    @endif
                @endif
            @endif
            <!-- super admin only -->

        </div>
    </div>
    <div class="card-footer">
        <a href="/hospital/{{$hospital->id}}/station/{{$beds[0]->station_id}}/room" class="btn btn-danger btn-sm">
            <i class="fa fa-arrow-left"></i> Back
        </a>
    </div>
</div>


<div class="modal fade" id="modal-lg">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <h4 class="modal-title">
                    <i class="fas fa-exclamation-triangle"></i>
                    Delete warning!
                </h4>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                <div class="alert alert-warning alert-dismissible mb-0">
                    <h5>
                        This action cannot be undone.<br>
                        Click "Delete" button to delete this room.
                    </h5>
                </div>
            </div>

            <form action="/hospital/room/{{$beds[0]->id}}" method="post">
                @method('DELETE')
                @csrf
                <div class="modal-footer justify-content-center">
                    <button type="submit" class="btn btn-danger">Delete</button>
                    <button type="button" class="btn btn-default" data-dismiss="modal">Cancel</button>
                </div>
            </form>

        </div>
    </div>
</div>

@endsection
