<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateDepartmentBedsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('department_beds', function (Blueprint $table) {
            $table->id();
            $table->integer('hospital_id');
            $table->boolean('status')->default(true);
            $table->string('bed');
            $table->string('description')->nullable();
            $table->string('ref_id')->nullable();
            $table->string('type');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('department_beds');
    }
}
