<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateReferralsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('referrals', function (Blueprint $table) {
            $table->id();
            $table->string('referral_no');
            $table->string('patient');
            $table->integer('age');
            $table->string('sex');
            $table->dateTime('birthdate', $precision = 0);
            $table->string('civil_status')->nullable();
            $table->string('address');
            $table->string('occupation')->nullable();
            $table->string('religion')->nullable();
            $table->string('guardian');
            $table->boolean('is_pwd')->default(false);
            $table->boolean('is_sc')->default(false);
            $table->boolean('is_ic')->default(false);
            $table->text('complaint');
            $table->string('vs_bp')->nullable();
            $table->string('vs_hr')->nullable();
            $table->string('vs_rr')->nullable();
            $table->string('vs_temp')->nullable();
            $table->string('vs_weight')->nullable();
            $table->string('obh_g')->nullable();
            $table->string('obh_p')->nullable();
            $table->string('obh_lmp')->nullable();
            $table->string('obh_edc')->nullable();
            $table->string('obh_aog')->nullable();
            $table->string('obh_fh')->nullable();
            $table->string('obh_fhr')->nullable();
            $table->string('obh_pelvic')->nullable();
            $table->text('hx_n_pe')->nullable();
            $table->text('medication')->nullable();
            $table->text('diagnosis');
            $table->text('reason');
            $table->string('phic_id_no')->nullable();
            $table->integer('ref_from_hospital')->nullable();
            $table->date('ref_from_date');
            $table->time('ref_from_time');
            $table->integer('ref_to_hospital')->nullable();
            $table->date('ref_to_date')->nullable();
            $table->time('ref_to_time')->nullable();
            $table->string('ref_by');
            $table->string('contact_no');
            $table->integer('created_by');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('referrals');
    }
}
