<?php

namespace App;

use Illuminate\Contracts\Auth\MustVerifyEmail;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Notifications\Notifiable;

class User extends Authenticatable
{
    use Notifiable;

    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = [
        'fname', 'lname', 'email', 'password', 'role', 'hospital_id', 'drrmo_id'
    ];

    /**
     * The attributes that should be hidden for arrays.
     *
     * @var array
     */
    protected $hidden = [
        'password', 'remember_token',
    ];

    /**
     * The attributes that should be cast to native types.
     *
     * @var array
     */
    protected $casts = [
        'email_verified_at' => 'datetime',
    ];

    public function referral()
    {
        return $this->hasMany(Referral::class, 'created_by', 'id');
    }

    public function audit_trail()
    {
        return $this->hasMany(AuditTrail::class, 'user_id', 'id');
    }

    public function assigned_user()
    {
        return $this->hasOne(AssignedUser::class, 'user_id', 'id');
    }


}
