<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class Station extends Model
{
    protected $fillable = ['hospital_id', 'station', 'description'];


    public function room()
    {
        return $this->hasMany(Room::class, 'station_id', 'id');
    }

    public function bed()
    {
        return $this->hasMany(Bed::class, 'station_id', 'id');
    }

    //inverse
    public function hospital()
    {
        return $this->belongsTo(Hospital::class, 'hospital_id', 'id');
    }
}
