<?php

namespace App;

use App\Comment;
use Illuminate\Database\Eloquent\Model;

class Referral extends Model
{
    protected $fillable = [
        'referral_no', 'ref_ctr', 'patient', 'age', 'sex', 'birthdate', 'civil_status', 'address', 'occupation', 'religion', 'guardian',
        'state', 'complaint', 'vs_bp', 'vs_hr', 'vs_rr', 'vs_temp', 'vs_weight', 'obh_g', 'obh_p', 'obh_lmp', 'obh_edc', 'obh_aog',
        'obh_fh', 'obh_fhr', 'obh_pelvic', 'hx_n_pe', 'diagnosis', 'medication', 'reason', 'phic_id_no', 'ref_from_hospital', 'ref_from_drrmo', 'ref_to_hospital',
        'ref_from_date', 'ref_from_time', 'ref_to_date', 'ref_to_time', 'ref_by', 'contact_no', 'created_by', 'ref_status', 'remarks', 'is_dept_bed', 'is_internal',
        'o2_sat', 'add_instruction', 'rtpcr', 'vaccine_1st_dose', 'vaccine_2nd_dose', 'rat', 'referral_type', 'rtpcr_attach', 'rat_attach'
    ];

    //inverse
    public function hospital()
    {
        return $this->belongsTo(Hospital::class, 'ref_from_hospital', 'id');
    }

    public function user()
    {
        return $this->belongsTo(User::class, 'user_id', 'id');
    }

    public function comments()
    {
        return $this->hasMany(Comment::class);
    }
}
