<?php

namespace App\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;

class ResetUserPasswordEmail extends Mailable
{
    use Queueable, SerializesModels;

    /**
     * Create a new message instance.
     *
     * @return void
     */
    public $email_data;
    public function __construct($data)
    {
        $this->email_data = $data;
    }

    /**
     * Build the message.
     *
     * @return $this
     */
    public function build()
    {
        // return $this->from(env('MAIL_USERNAME', 'josegenelidojrc@gmail.com'))
        //             ->subject('One Hospital Command System - New Password')
        //             ->view('users.email.pass-reset-email', ['email_data'=>$this->email_data]);


        return $this->from(env('MAIL_USERNAME', 'josegenelidojrc@gmail.com'))
                    ->subject('One Hospital Command System - New Password')
                    ->view('users.email.pass-reset-email', ['email_data'=>$this->email_data]);
    }
}
