<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\User;
use App\Hospital;
use App\AssignedUser;
use App\AuditTrail;
use App\Drrmo;
class UserController extends Controller
{
    public function __construct()
    {
        $this->middleware('superadmin');
    }
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $data = [
            'users'  => User::orderBy('created_at', 'desc')->get(),
            'unassigned_users'  => User::where('assigned', false)->orderBy('created_at', 'desc')->get(),
            'assigned_user' => User::with('assigned_user')->where('assigned', true)->orderBy('created_at', 'desc')->get(),
            'hospitals' => Hospital::with('station')->orderBy('created_at', 'desc')->get(),
            'drrmos'    => Drrmo::get()
        ];

        return view('users.index', $data);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show(User $user)
    {
        $assigned = User::find($user->id)->assigned_user;
        $data = [
            'user' => $user,
            'hospital' => Hospital::find($assigned->hospital_id),
            'assigned' => $assigned,
            'hospitals' => Hospital::with('station')->orderBy('created_at', 'desc')->get(),
            'audit_trails' => AuditTrail::where('user_id', $user->id)->orderBy('created_at', 'desc')->get()
        ];

        return view('users.show', $data);
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }
}
