<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Referral;
use App\Patient;
use App\Bed;
use App\DepartmentBed;

class TransferPatientController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth');
    }

    public function transfer(Referral $referral, Request $request)
    {
        // get patient details
        $patient = Patient::where('referral_id', $referral->id)->first();

        if($referral->is_dept_bed) { // patient is currently in department bed
            // set current bed status to green

            DepartmentBed::where('ref_id', $referral->id)
                    ->update([
                        'status'    =>  1,
                        'ref_id'    =>  null,
                        'ref_no'    =>  null
                    ]);

            //check newly selected bed
            if($request->bed_id) { // if the newly selected bed is under station beds

                // set referral is dept bed = false because the new bed is under station beds
                $referral->is_dept_bed = false;
                $referral->save();

                $bed = Bed::find($request->bed_id);

                if($patient == null) { // if no patient record
                    // create patient record
                    $patient = new Patient();
                    $patient->referral_id = $referral->id;
                    $patient->status = $referral->ref_status;
                    $patient->hospital_id = $bed->hospital_id;
                    $patient->station_id = $bed->station_id;
                    $patient->room_id = $bed->room_id;
                    $patient->bed_id = $bed->id;
                    $patient->bed_no = $bed->bed;
                    $patient->save();
                }

                Bed::where('id', $request->bed_id)
                    ->update([
                                'status'        =>  $referral->ref_status,
                                'patient_id'    =>  $patient->id,
                                'ref_no'        =>  $referral->referral_no
                            ]);
                $patient->station_id = $bed->station_id;
                $patient->room_id = $bed->room_id;
                $patient->bed_id = $bed->id;
                $patient->bed_no = $bed->bed;
                $patient->save();

            } elseif($request->dept_bed_id) { // if the newly selected bed is under dept beds
                // put referral data under the selected bed
                DepartmentBed::where('id', $request->dept_bed_id)
                    ->update([
                        'status'    =>  $referral->ref_status,
                        'ref_id'    =>  $referral->id,
                        'ref_no'    =>  $referral->referral_no
                    ]);

                $referral->is_dept_bed = true;
                $referral->save();
            }
        } else { // patient is currently in station bed

            // set status available to current bed
            Bed::where('ref_no', $referral->referral_no)
                ->update([
                            'status'=>1,
                            'patient_id'=>null,
                            'ref_no'=>null
                        ]);

            //insert referral in newly selected bed
            if($request->bed_id) { // if newly selected bed is under station beds
                Bed::where('id', $request->bed_id)
                    ->update([
                                'status'        =>  $referral->ref_status,
                                'patient_id'    =>  $patient->id,
                                'ref_no'        =>  $referral->referral_no
                            ]);
                $bed = Bed::find($request->bed_id);
                $patient->station_id = $bed->station_id;
                $patient->room_id = $bed->room_id;
                $patient->bed_id = $bed->id;
                $patient->bed_no = $bed->bed;
                $patient->save();
            } elseif ($request->dept_bed_id) { // if newly selected bed is under dept beds
                DepartmentBed::where('id', $request->dept_bed_id)
                    ->update([
                        'status'    =>  $referral->ref_status,
                        'ref_id'    =>  $referral->id,
                        'ref_no'    =>  $referral->referral_no
                    ]);

                $referral->is_dept_bed = true;
                $referral->save();
            }

        }

        return redirect('referral/'.$referral->id);


        // if(isset($request->bed_id)) {
        //     if($patient == null) {
        //         $bed = Bed::where('id', $request->bed_id)->first();
        //         $patient = new Patient();
        //         $patient->referral_id = $referral->id;
        //         $patient->status = 3;
        //         $patient->hospital_id = $bed->hospital_id;
        //         $patient->station_id = $bed->station_id;
        //         $patient->room_id = $bed->room_id;
        //         $patient->bed_id = $bed->id;
        //         $patient->bed_no = $bed->bed;
        //         $patient->save();

        //         $bed->status = $referral->ref_status;
        //         $bed->patient_id = $patient->id;
        //         // $bed->ref_id = $referral->id;
        //         $bed->ref_no = $referral->referral_no;
        //         $bed->save();

        //         $dept_bed = DepartmentBed::where('ref_id', $referral->id)->first();
        //         $dept_bed->status = 1;
        //         $dept_bed->ref_id = null;
        //         $dept_bed->ref_no = null;
        //         $dept_bed->save();

        //         $referral->is_dept_bed = false;
        //         $referral->save();
        //     } else {
        //         $dept_bed = DepartmentBed::where('ref_id', $referral->id)->first();
        //         if($dept_bed != null) {
        //             $dept_bed->status = 1;
        //             $dept_bed->ref_id = null;
        //             $dept_bed->ref_no = null;
        //             $dept_bed->save();

        //             $referral->is_dept_bed = false;
        //             $referral->save();
        //         }


        //         Bed::where('patient_id', $patient->id)->update([
        //             'status'=> 1,
        //             'patient_id'=>null,
        //             'ref_no'=>null
        //         ]);
        //         Bed::where('id', $request->bed_id)->update([
        //             'status'=>$referral->ref_status,
        //             'patient_id'=>$patient->id,
        //             'ref_no'=>$referral->referral_no
        //         ]);

        //         $bed = Bed::where('id', $request->bed_id)->first();

        //         $patient->station_id = $bed->station_id;
        //         $patient->room_id = $bed->room_id;
        //         $patient->bed_id = $bed->id;
        //         $patient->bed_no = $bed->bed;
        //         $patient->save();
        //     }
        // } elseif(isset($request->dept_bed_id)) {
        //     $dept_bed = DepartmentBed::where('ref_id', $referral->id)->first();
        //     if($dept_bed != null) {
        //         $dept_bed->status = 1;
        //         $dept_bed->ref_id = null;
        //         $dept_bed->ref_no = null;
        //         $dept_bed->save();
        //     }

        //     if($patient != null) {
        //         $bed = Bed::where('patient_id', $patient->id)->first();
        //         if($bed != null) {
        //             Bed::where('patient_id', $patient->id)->update([
        //                 'status'=> 1,
        //                 'patient_id'=>null,
        //                 'ref_no'=>null
        //             ]);
        //         }
        //     }

        //     $dept_bed = DepartmentBed::where('id', $request->dept_bed_id)->first();
        //     $dept_bed->status = 3;
        //     $dept_bed->ref_id = $referral->id;
        //     $dept_bed->ref_no = $referral->referral_no;
        //     $dept_bed->save();

        //     $referral->is_dept_bed = true;
        //     $referral->save();
        // }


    }

    public function select(Referral $referral)
    {

    }

}
