<?php

namespace App\Http\Controllers;
use App\Bed;
use App\Room;
use App\Station;
use App\Hospital;
use Illuminate\Http\Request;

class StationController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        //
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create(Hospital $hospital, Request $request)
    {
        $data = [
            'hospital'  => $hospital,
            'stations'  => Station::where('hospital_id', $hospital->id)->get()
        ];

        if(isset($request->id)) {
            $data['station'] = Station::where('id', $request->id)->first();
        }
        return view('hospitals.station.create', $data);
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $request->validate([
            'hospital_id' => 'required',
            'station' => 'required|max:255'
        ]);

        $hospital = Hospital::select('hospital')->where('id', $request->hospital_id)->first();

        Station::create(request()->all());

        AuditTrailController::store(
            'station',
            'create',
            'Create station, '.$hospital->hospital. ' - '. $request->station
        );

        return redirect()->back()->with('station.store', true);
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Station  $station
     * @return \Illuminate\Http\Response
     */
    public function show(Station $station)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Station  $station
     * @return \Illuminate\Http\Response
     */
    public function edit(Station $station)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Station  $station
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, Station $station)
    {
        $station = Station::where('id', $request->id)->first();
        $station->station = $request->station;
        $station->description = $request->description;
        $station->save();

        return redirect('hospital/'.$station->hospital_id.'/station')->with('station.update', true);
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Station  $station
     * @return \Illuminate\Http\Response
     */
    public function destroy(Station $station, Request $request)
    {
        $station = Station::find($request->del_station_id);
        $bed = Bed::where('station_id', $station->id)->get();
        if(count($bed) > 0) {
            AuditTrailController::store(
                'station',
                'delete',
                'Attempting to delete station ['.$station->station.'] with occupied bed | time ['.now().']'
            );
            return redirect()->back();
        }

        $station = Station::where('id', $request->del_station_id)->first();
        Station::destroy($station->id);
        Room::where('station_id', $station->id)->delete();
        Bed::where('station_id', $station->id)->delete();

        $hospital = Hospital::select('hospital')->where('id', $station->hospital_id)->first();

        AuditTrailController::store(
            'station',
            'delete',
            'Delete station, '.$hospital->hospital. ' - '. $station->station
        );
        return redirect()->back()->with('station.destroy', true);
    }
}
