<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Hospital;
use App\Referral;
use App\Drrmo;
use Illuminate\Support\Facades\Auth;

class PrintController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth');
    }

    public function print_referral(Referral $referral)
    {
        // $data = [
        //     'hospital'  => Hospital::where('id', Auth::user()->hospital_id)->first(),
        //     'referral'  => Referral::where('id', $request->id)->first()
        // ];

        $data = [
            'referral'  => $referral,
            'receivingH' => Hospital::find($referral->ref_to_hospital)
        ];

        if ($referral->is_internal) {
            $data['referringH'] = Hospital::find($referral->ref_to_hospital);
        } else {
            if ($referral->ref_from_hospital == null) {
                $data['referringH'] = Drrmo::find($referral->ref_from_drrmo);
            } elseif ($referral->ref_from_drrmo == null) {
                $data['referringH'] = Hospital::find($referral->ref_from_hospital);
            }
        }



        // dd($data);

        return view('print.print_referral', $data);
    }

    public function print_referral_blank()
    {
        if (Auth::user()->role != 1) return redirect()->back();
        $data = [
            'hospital' => Hospital::select('hospital')->where('id', Auth::user()->hospital_id)->first()
        ];
        return view('print.blank_referral', $data);
    }
}
