<?php

namespace App\Http\Controllers;

use App\Notification;
use App\Referral;
use Pusher\Pusher;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class NotificationController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth');
    }



    // Save new notification
    public static function store($type, $notif, $link, $rec_type, $rec_id, $ref_no, $div_id)
    {
        $data = array(
            'link'  => $link,
            'notif' => $notif
        );

        $options = array(
            'cluster'   =>  'ap1',
            'useTLS'    =>  true
        );

        $pusher = new Pusher(
            '865ca245429677accfa1',
            '9763b9f99ce4cde7cb9a',
            '1115790',
            $options
        );
        $referral = Referral::where('referral_no', $ref_no)->first();
        switch ($type) {
            case 'referral':
                switch ($referral->ref_status) {
                    case 1:
                        $pusher->trigger('one-hospital', 'newref', $data);
                        break;
                    case 2:
                        $pusher->trigger('one-hospital', 'incto'.$rec_id, $data);
                        if($referral->ref_from_hospital) {
                            $pusher->trigger('one-hospital', 'referred'.$referral->ref_from_hospital, $data);
                        } elseif($referral->ref_from_drrmo) {
                            $pusher->trigger('one-hospital', 'referred'.$referral->ref_from_drrmo, $data);
                        }
                        break;
                    case 3: 
                        if($referral->ref_from_hospital) {
                            $pusher->trigger('one-hospital', 'admitted'.$referral->ref_from_hospital, $data);
                        } elseif($referral->ref_from_drrmo) {
                            $pusher->trigger('one-hospital', 'admitted'.$referral->ref_from_drrmo, $data);
                        }
                        break;
                    default:
                        # code...
                        break;
                }
                break;

            case 'comment':
                if($rec_type == 2) {
                    $pusher->trigger('one-hospital', 'cmnt', $data);
                } else {
                    $pusher->trigger('one-hospital', 'cmnt'.$rec_id, $data);
                }
                break;
            
            default:
                # code...
                break;
        }









        // if($type == 'referral') {
        //     // Notifications
        //     // Incoming referral to hospital - INCREFTO
        //     // New referral - NEWREF
        //     switch ($rec_role) {
        //         case '1':
        //             // HOSPITAL
        //             $referral = Referral::where('referral_no', $ref_no)->first();
        //             $pusher->trigger('one-hospital', 'increfto'.$referral->ref_to_hospital, $data);
        //             break;

        //         case '2':
        //             // HOD
        //             $pusher->trigger('one-hospital', 'newref', $data);
        //             break;

        //         default:
        //             # code...
        //             break;
        //     }
        // } elseif ($type == 'dispatch') {
        //     // Will notify the HOD & the receiver
        //     // Dispatched ambulance from referring hospital to referred hospital - INCAMBTO
        //     $referral = Referral::where('referral_no', $ref_no)->first();
        //     $pusher->trigger('one-hospital', 'incambto'.$referral->ref_to_hospital, $data);
        // } elseif($type == 'receive') {
        //     // Will notify the referring hospital & HOD
        //     // Referral arrived at referred hospital - ARRREFTO
        //     $referral = Referral::where('referral_no', $ref_no)->first();
        //     $pusher->trigger('one-hospital', 'arrrefto'.$referral->ref_from_hospital, $data);
        // } elseif($type == 'referred') {
        //     $referral = Referral::where('referral_no', $ref_no)->first();
        //     $pusher->trigger('one-hospital', 'increffrom'.$referral->ref_to_hospital, $data);
        // } elseif($type == 'comment') {
        //     $referral = Referral::where('referral_no', $ref_no)->first();
            
        //     if($rec_role == '2') {
        //         $pusher->trigger('one-hospital', 'cmntrcvr'.$rec_key, $data);
        //     } else {
        //         if()
        //     }
        // }

        $notification = new Notification();
        $notification->type = $type;
        $notification->notification = $notif;
        $notification->link = $link;
        $notification->receiver_role = $rec_type;
        $notification->receiver_key = $rec_id;
        $notification->div_id = $div_id;
        $notification->save();
    }



    // Get all hod notifications
    public function hod_notifications()
    {
        if(Auth::user()->role != 2) {
            return redirect()->back();
        }
        $data = [
            'notifs'        => Notification::where([ ['receiver_role', 2], ['is_seen', false] ])->get(),
            'notifications' => Notification::where('receiver_role', 2)->orderBy('created_at', 'desc')->paginate(15)
        ];
        return view('notification.index', $data);
    }


    // Get all hospital notifications
    public function hospital_notifications()
    {
        if(Auth::user()->role != 1) {
            return redirect()->back();
        }
        $key = Auth::user()->hospital_id;
        $data = [
            'notifs'        => Notification::where([ ['receiver_role', 1], ['is_seen', false] ])->get(),
            'notifications' => Notification::where([ ['receiver_role', 1], ['receiver_key', $key] ])->orderBy('created_at', 'desc')->paginate(15)
        ];
        return view('notification.index', $data);
    }


    // Get all drrmo notifications
    public function drrmo_notifications()
    {
        if(Auth::user()->role != 4) {
            return redirect()->back();
        }
        $key = Auth::user()->drrmo_id;
        $data = [
            'notifs'        => Notification::where([ ['receiver_key', $key], ['is_seen', false] ])->get(),
            'notifications' => Notification::where([ ['receiver_key', $key] ])->orderBy('created_at', 'desc')->paginate(15)
        ];
        return view('notification.index', $data);
    }


    // Get all notifications
    public function all_notifications()
    {
        if(Auth::user()->role != 3) {
            return redirect()->back();
        }
        $notifications = Notification::orderBy('created_at', 'desc')->paginate(15);
        return view('notification.index', ['notifications'=>$notifications]);
    }
}
