<?php

namespace App\Http\Controllers;
use App\Drrmo;
use App\Notification;
use Illuminate\Support\Facades\Auth;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;

class DrrmoController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth');
    }

    public function index()
    {
        $data = [
            'drrmos'     => Drrmo::get(),
            // 'notifs'     => Notification::where([ ['receiver_role', 2], ['is_seen', false] ])->get()
        ];

        if (Auth::user()->role == 2) {
            $data['notifs'] = Notification::where([ ['receiver_role', 2], ['is_seen', false] ])->get();
        }

        return view('drrmo.index', $data);
    }

    public function create()
    {
        $data = [
            'drrmos'     => Drrmo::get()
        ];
        return view('drrmo.create', $data);
    }

    public function store(Request $request)
    {

        $validator = Validator::make($request->all(), [
            'drrmo' => 'required|unique:drrmos|max:255',
            'address' => 'required',
        ]);

        if ($validator->fails()) {
            return redirect()->back()->with('store', false);
        }

        $drrmo = new Drrmo();
        $drrmo->drrmo = $request->drrmo;
        $drrmo->address =$request->address;
        $drrmo->created_by = Auth::user()->id;
        $code = '';
        $d = explode(" ", $request->drrmo);
        foreach ($d as $i) {
            $code .= $i[0];
        }
        $drrmo->code = $code;
        $drrmo->save();

        return redirect()->back()->with('store', true);
    }

    public function show(Drrmo $drrmo)
    {
        return view('drrmo.show', ['drrmo'=>$drrmo]);
    }

    public function destroy(Drrmo $drrmo)
    {
        Drrmo::where('id', $drrmo->id)->delete();
        return redirect()->back();
    }
}
