<?php

namespace App\Http\Controllers;

use App\AssignedUser;
use App\Hospital;
use App\Station;
use App\Room;
use App\Bed;
use App\Referral;
use App\Ambulance;
use App\Doctor;
use App\Notification;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use DB;

class DashboardController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth');
    }
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {

        $role = Auth::user()->role;

        if ($role == 1) {
            $hospital_id = Auth::user()->hospital_id;

            $data = [
                'hospital'  => Hospital::where('id', $hospital_id)->first(),
                'station'   => Hospital::with('station')->where('id', $hospital_id)->get(),
                'room'      => Hospital::with('room')->where('id', $hospital_id)->get(),
                'bed'       => Hospital::with('bed')->where('id', $hospital_id)->get(),
                'hospitals' => Hospital::with('station')->orderBy('created_at', 'desc')->get(),
            ];


            $beds = Bed::where('beds.hospital_id', $hospital_id)
                ->select('beds.id', 'beds.bed', 'beds.status', 'beds.patient_id', 'beds.hospital_id', 'beds.station_id', 'beds.room_id', 'stations.station', 'rooms.room')
                ->join('stations', 'stations.id', '=', 'beds.station_id')
                ->join('rooms', 'rooms.id', '=', 'beds.room_id')
                ->get();
            $data['beds'] = $beds;


            $stations = Station::where('hospital_id', $hospital_id)->get();
            $data['stations'] = $stations;

            $rooms = Room::where('hospital_id', $hospital_id)->get();
            $data['rooms'] = $rooms;

            $ambulances = Ambulance::where('hospital_id', $hospital_id)->get();
            $data['ambulances'] = $ambulances;

            $doctors = Doctor::where('hospital_id', $hospital_id)->get();
            $data['doctors'] = $doctors;

            $data['notifs'] = Notification::where([['receiver_key', Auth::user()->hospital_id], ['is_seen', false]])->get();

            return view('hospitals.show', $data);
        } elseif ($role == 2 || $role == 3) {
            $data = [
                'occupied'      => Bed::select(DB::raw('count(*) as occupied, hospitals.hospital'))
                    ->join('hospitals', 'hospitals.id', '=', 'beds.hospital_id')
                    ->where('beds.status', '!=', 1)
                    ->groupBy('hospitals.hospital')
                    ->get(),
                'available'     => Bed::select(DB::raw('count(*) as available, hospitals.hospital'))
                    ->join('hospitals', 'hospitals.id', '=', 'beds.hospital_id')
                    ->where('beds.status', '=', 1)
                    ->groupBy('hospitals.hospital')
                    ->get(),
                'regular_beds'  => Bed::select(DB::raw('count(*) as total_beds'), 'hospitals.hospital', 'hospitals.id', 'hospitals.code')
                    ->join('hospitals', 'hospitals.id', '=', 'beds.hospital_id')
                    ->groupBy('hospitals.hospital', 'hospitals.id', 'hospitals.code')
                    ->orderBy('total_beds', 'desc')
                    ->get()
            ];

            if ($role == 2) {
                $data['notifs'] = Notification::where([['receiver_role', 2], ['is_seen', false]])->get();
            }

            return view('dashboard.index', $data);
        }
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }
}
