<?php

namespace App\Http\Controllers;

use App\Ambulance;
use App\Referral;
use Illuminate\Http\Request;

class AmbulanceController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        //
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        return view('hospitals.ambulance.create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $ambulance = new Ambulance();
        $ambulance->ambulance = $request->ambulance;
        $ambulance->driver = $request->driver;
        $ambulance->crew = $request->crew;
        $ambulance->hospital_id = $request->hospital_id;
        $ambulance->save();

        return redirect('/hospital/'.$request->hospital_id);
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Ambulance  $ambulance
     * @return \Illuminate\Http\Response
     */
    public function show(Ambulance $ambulance)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Ambulance  $ambulance
     * @return \Illuminate\Http\Response
     */
    public function edit(Ambulance $ambulance)
    {
        $data = [
            'ambulance' => $ambulance
        ];

        return view('hospitals.ambulance.edit', $data);
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Ambulance  $ambulance
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, Ambulance $ambulance)
    {
        Ambulance::where('id', $request->id)->update([
            'driver'  =>  $request->driver,
            'ambulance' => $request->ambulance,
            'crew'  => $request->crew
        ]);

        return redirect('/hospital/'.$request->hospital_id);
    }

    public function update_list(Request $request)
    {
        Ambulance::where('hospital_id', $request->hospital_id)->update([
            'status'  =>  false,
            'latest_update' => now(),
            'ref_id'    => null,
            'ref_no'    => null
        ]);

        if($request->status != null)
        {
            $ids = $request->status;
            for ($i=0; $i < count($ids)  ; $i++) {
                Ambulance::where('id', $ids[$i])->update([
                    'status'        =>  true
                ]);
            }
        }
        return redirect()->back();
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Ambulance  $ambulance
     * @return \Illuminate\Http\Response
     */
    public function destroy(Ambulance $ambulance, Request $request)
    {
        Ambulance::where('id', $request->ambulance_id)->delete();
        return redirect()->back();
    }

    public function dispatch_ambu(Request $request)
    {
        $hospital_id = $request->hospital_id;
        $data = [
            'ambulances'        => Ambulance::where([
                                            ['hospital_id', $hospital_id],
                                            ['status', true]
                                        ])->get(),
            'referrals'         => Referral::where([
                                            ['ref_status', 2],
                                            ['ref_from_hospital', $hospital_id]
                                        ])->get()
        ];

        return view('hospitals.ambulance.dispatch', $data);
    }

    public function dispatch_ambu_update(Request $request)
    {
        $referral = Referral::where('id', $request->ref_id)->first();
        Ambulance::where('id', $request->id)->update([
            'status'  =>  false,
            'latest_update' => now(),
            'ref_id'    => $request->ref_id,
            'ref_no'    => $referral->referral_no
        ]);

        return redirect('/hospital/'.$request->hospital_id);
    }
}
